/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.jsr107.CacheResources;
import org.ehcache.jsr107.ConfigurationMerger;
import org.ehcache.jsr107.Eh107Cache;
import org.ehcache.jsr107.Eh107CompleteConfiguration;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.Eh107InternalCacheManager;
import org.ehcache.jsr107.Eh107MXBean;
import org.ehcache.jsr107.Eh107ReverseConfiguration;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.ehcache.jsr107.EhcacheExpiryWrapper;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.Unwrap;
import org.ehcache.jsr107.internal.Jsr107CacheLoaderWriter;
import org.ehcache.jsr107.internal.WrappedCacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Eh107CacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(Eh107CacheManager.class);
    private static MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private final Object cachesLock = new Object();
    private final ConcurrentMap<String, Eh107Cache<?, ?>> caches = new ConcurrentHashMap();
    private final Eh107InternalCacheManager ehCacheManager;
    private final EhcacheCachingProvider cachingProvider;
    private final ClassLoader classLoader;
    private final URI uri;
    private final Properties props;
    private final ConfigurationMerger configurationMerger;

    Eh107CacheManager(EhcacheCachingProvider cachingProvider, Eh107InternalCacheManager ehCacheManager, Properties props, ClassLoader classLoader, URI uri, ConfigurationMerger configurationMerger) {
        this.cachingProvider = cachingProvider;
        this.ehCacheManager = ehCacheManager;
        this.props = props;
        this.classLoader = classLoader;
        this.uri = uri;
        this.configurationMerger = configurationMerger;
        this.refreshAllCaches();
    }

    Eh107InternalCacheManager getEhCacheManager() {
        return this.ehCacheManager;
    }

    private void refreshAllCaches() {
        for (Map.Entry<String, CacheConfiguration<?, ?>> entry : this.ehCacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
            String name = entry.getKey();
            CacheConfiguration<?, ?> config = entry.getValue();
            this.caches.putIfAbsent(name, this.wrapEhcacheCache(name, config));
        }
        for (Map.Entry<String, CacheConfiguration<Object, Object>> entry : this.caches.entrySet()) {
            Eh107Cache cache = (Eh107Cache)((Object)entry.getValue());
            if (cache.isClosed()) continue;
            Eh107Configuration configuration = cache.getConfiguration(Eh107Configuration.class);
            if (configuration.isManagementEnabled()) {
                this.enableManagement(cache, true);
            }
            if (!configuration.isStatisticsEnabled()) continue;
            this.enableStatistics(cache, true);
        }
    }

    private <K, V> Eh107Cache<K, V> wrapEhcacheCache(String alias, CacheConfiguration<K, V> ehConfig) {
        Cache<K, V> cache = this.ehCacheManager.getCache(alias, ehConfig.getKeyType(), ehConfig.getValueType());
        return this.wrapEhcacheCache(alias, (InternalCache)cache);
    }

    private <K, V> Eh107Cache<K, V> wrapEhcacheCache(String alias, InternalCache<K, V> cache) {
        CacheLoaderWriter<K, V> cacheLoaderWriter = cache.getCacheLoaderWriter();
        boolean storeByValueOnHeap = false;
        for (ServiceConfiguration<?> serviceConfiguration : cache.getRuntimeConfiguration().getServiceConfigurations()) {
            if (!(serviceConfiguration instanceof DefaultCopierConfiguration)) continue;
            DefaultCopierConfiguration copierConfig = (DefaultCopierConfiguration)serviceConfiguration;
            if (copierConfig.getClazz().isAssignableFrom(IdentityCopier.class)) break;
            storeByValueOnHeap = true;
            break;
        }
        Eh107ReverseConfiguration<K, V> config = new Eh107ReverseConfiguration<K, V>(cache, cacheLoaderWriter != null, cacheLoaderWriter != null, storeByValueOnHeap);
        this.configurationMerger.setUpManagementAndStats(cache, config);
        EhcacheExpiryWrapper expiry = new EhcacheExpiryWrapper(cache.getRuntimeConfiguration().getExpiry());
        CacheResources<K, V> resources = new CacheResources<K, V>(alias, this.wrapCacheLoaderWriter(cacheLoaderWriter), expiry);
        return new Eh107Cache<K, V>(alias, config, resources, cache, this);
    }

    private <K, V> Jsr107CacheLoaderWriter<K, V> wrapCacheLoaderWriter(CacheLoaderWriter<K, V> cacheLoaderWriter) {
        return new WrappedCacheLoaderWriter<K, V>(cacheLoaderWriter);
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Properties getProperties() {
        return new Properties(this.props);
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C config) throws IllegalArgumentException {
        this.checkClosed();
        if (cacheName == null || config == null) {
            throw new NullPointerException();
        }
        Object object = this.cachesLock;
        synchronized (object) {
            InternalCache ehCache;
            if (config instanceof Eh107Configuration.Eh107ConfigurationWrapper) {
                Cache ehcache;
                Eh107Configuration.Eh107ConfigurationWrapper configurationWrapper = (Eh107Configuration.Eh107ConfigurationWrapper)config;
                CacheConfiguration unwrap = configurationWrapper.getCacheConfiguration();
                try {
                    ehcache = this.ehCacheManager.createCache(cacheName, unwrap);
                }
                catch (IllegalArgumentException e) {
                    throw new CacheException("A Cache named [" + cacheName + "] already exists");
                }
                Eh107Cache<K, V> cache = this.wrapEhcacheCache(cacheName, (InternalCache)ehcache);
                assert (this.safeCacheRetrieval(cacheName) == null);
                this.caches.put(cacheName, cache);
                return cache;
            }
            ConfigurationMerger.ConfigHolder configHolder = this.configurationMerger.mergeConfigurations(cacheName, config);
            try {
                ehCache = (InternalCache)this.ehCacheManager.createCache(cacheName, configHolder.cacheConfiguration);
            }
            catch (IllegalArgumentException e) {
                MultiCacheException mce = new MultiCacheException(e);
                configHolder.cacheResources.closeResources(mce);
                throw new CacheException("A Cache named [" + cacheName + "] already exists", (Throwable)((Object)mce));
            }
            catch (Throwable t) {
                MultiCacheException mce = new MultiCacheException(t);
                configHolder.cacheResources.closeResources(mce);
                throw mce;
            }
            Eh107Cache cache = null;
            CacheResources cacheResources = configHolder.cacheResources;
            try {
                if (configHolder.useEhcacheLoaderWriter) {
                    cacheResources = new CacheResources(cacheName, this.wrapCacheLoaderWriter(ehCache.getCacheLoaderWriter()), cacheResources.getExpiryPolicy(), cacheResources.getListenerResources());
                }
                cache = new Eh107Cache(cacheName, new Eh107CompleteConfiguration(configHolder.jsr107Configuration, ehCache.getRuntimeConfiguration()), cacheResources, ehCache, this);
                this.caches.put(cacheName, cache);
                if (configHolder.jsr107Configuration.isManagementEnabled()) {
                    this.enableManagement(cacheName, true);
                }
                if (configHolder.jsr107Configuration.isStatisticsEnabled()) {
                    this.enableStatistics(cacheName, true);
                }
                return cache;
            }
            catch (Throwable t) {
                MultiCacheException mce = new MultiCacheException(t);
                if (cache != null) {
                    cache.closeInternal(mce);
                } else {
                    cacheResources.closeResources(mce);
                }
                throw mce;
            }
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(this.toString() + " is closed");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.uri + "]";
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkClosed();
        if (cacheName == null || keyType == null || valueType == null) {
            throw new NullPointerException();
        }
        Eh107Cache<K, V> cache = this.safeCacheRetrieval(cacheName);
        if (cache == null) {
            return null;
        }
        Class actualKeyType = cache.getConfiguration(Configuration.class).getKeyType();
        Class actualValueType = cache.getConfiguration(Configuration.class).getValueType();
        if (keyType != actualKeyType) {
            throw new ClassCastException("Cache has key type " + actualKeyType.getName() + ", but getCache() called with key type " + keyType.getName());
        }
        if (valueType != actualValueType) {
            throw new ClassCastException("Cache has value type " + actualValueType.getName() + ", but getCache() called with value type " + valueType.getName());
        }
        return cache;
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache<K, V> cache = this.safeCacheRetrieval(cacheName);
        if (cache == null) {
            return null;
        }
        if (cache.getConfiguration(Configuration.class).getKeyType() != Object.class || cache.getConfiguration(Configuration.class).getValueType() != Object.class) {
            throw new IllegalArgumentException("Cache [" + cacheName + "] specifies key/value types. Use getCache(String, Class, Class)");
        }
        return cache;
    }

    private <K, V> Eh107Cache<K, V> safeCacheRetrieval(String cacheName) {
        Eh107Cache eh107Cache = (Eh107Cache)this.caches.get(cacheName);
        if (eh107Cache != null && eh107Cache.isClosed()) {
            return null;
        }
        return eh107Cache;
    }

    public Iterable<String> getCacheNames() {
        this.refreshAllCaches();
        return Collections.unmodifiableList(new ArrayList(this.caches.keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCache(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException();
        }
        MultiCacheException destroyException = new MultiCacheException();
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            Eh107Cache cache = (Eh107Cache)this.caches.remove(cacheName);
            if (cache == null) {
                return;
            }
            try {
                this.enableManagement(cache, false);
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
            try {
                this.enableStatistics(cache, false);
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
            cache.destroy(destroyException);
            try {
                this.ehCacheManager.removeCache(cache.getName());
            }
            catch (Throwable t) {
                destroyException.addThrowable(t);
            }
        }
        destroyException.throwIfNotEmpty();
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = this.safeCacheRetrieval(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No such Cache named " + cacheName);
        }
        this.enableManagement(cache, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableManagement(Eh107Cache<?, ?> cache, boolean enabled) {
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            if (enabled) {
                this.registerObject(cache.getManagementMBean());
            } else {
                this.unregisterObject(cache.getManagementMBean());
            }
            cache.setManagementEnabled(enabled);
        }
    }

    private void unregisterObject(Eh107MXBean bean) {
        try {
            MBEAN_SERVER.unregisterMBean(bean.getObjectName());
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void registerObject(Eh107MXBean bean) {
        try {
            LOG.info("Registering Ehcache MBean {}", (Object)bean.getObjectName());
            MBEAN_SERVER.registerMBean(bean, bean.getObjectName());
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = this.safeCacheRetrieval(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No such Cache named " + cacheName);
        }
        this.enableStatistics(cache, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableStatistics(Eh107Cache<?, ?> cache, boolean enabled) {
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            if (enabled) {
                this.registerObject(cache.getStatisticsMBean());
            } else {
                this.unregisterObject(cache.getStatisticsMBean());
            }
            cache.setStatisticsEnabled(enabled);
        }
    }

    public boolean isClosed() {
        return this.ehCacheManager.getStatus() == Status.UNINITIALIZED;
    }

    public <T> T unwrap(Class<T> clazz) {
        return Unwrap.unwrap(clazz, this, this.ehCacheManager);
    }

    public void close() {
        MultiCacheException closeException = new MultiCacheException();
        this.cachingProvider.close(this, closeException);
        closeException.throwIfNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal(MultiCacheException closeException) {
        try {
            Object object = this.cachesLock;
            synchronized (object) {
                for (Eh107Cache cache : this.caches.values()) {
                    try {
                        this.close(cache, closeException);
                    }
                    catch (Throwable t) {
                        closeException.addThrowable(t);
                    }
                }
                try {
                    this.caches.clear();
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    this.ehCacheManager.close();
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
            }
        }
        catch (Throwable t) {
            closeException.addThrowable(t);
        }
    }

    void close(Eh107Cache<?, ?> cache, MultiCacheException closeException) {
        block10: {
            try {
                if (!this.caches.remove(cache.getName(), cache)) break block10;
                try {
                    this.unregisterObject(cache.getManagementMBean());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    this.unregisterObject(cache.getStatisticsMBean());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    cache.closeInternal(closeException);
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
                try {
                    this.ehCacheManager.removeCache(cache.getName());
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
            }
            catch (Throwable t) {
                closeException.addThrowable(t);
            }
        }
    }
}

