/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXB;
import org.terracotta.config.TcConfig;
import org.terracotta.entity.ServiceProviderConfiguration;

public class TcConfiguration {
    private final TcConfig platformConfiguration;
    private final List<ServiceProviderConfiguration> serviceConfigurations;
    private final List<Object> objects;

    public TcConfiguration(TcConfig platformConfiguration, String source, List<Object> objects, List<ServiceProviderConfiguration> serviceConfigurations) {
        this.platformConfiguration = platformConfiguration;
        this.serviceConfigurations = serviceConfigurations;
        this.objects = objects;
    }

    public TcConfig getPlatformConfiguration() {
        return this.platformConfiguration;
    }

    public List<ServiceProviderConfiguration> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public <T> List<T> getExtendedConfiguration(Class<T> type) {
        return this.objects.stream().filter(o -> type.isInstance(o)).map(o -> type.cast(o)).collect(Collectors.toList());
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)this.platformConfiguration, (Writer)sw);
        return sw.toString();
    }
}

