/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.config.util;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.terracotta.config.TCConfigurationSetupException;

public class DefaultSubstitutor {
    private DefaultSubstitutor() {
    }

    public static void applyDefaults(Object root) {
        Class<?> clazz = root.getClass();
        if (clazz.getAnnotation(XmlType.class) == null) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getParameterTypes().length >= 1) continue;
            Object value = DefaultSubstitutor.methodInvoke(root, method);
            if (value == null) {
                Field field = DefaultSubstitutor.fieldFor(method);
                String def = DefaultSubstitutor.getDefaultFor(field);
                if (def == null) continue;
                Type type = DefaultSubstitutor.typeFor(method.getReturnType());
                if (type != null) {
                    DefaultSubstitutor.setField(root, field, type, def);
                    continue;
                }
                DefaultSubstitutor.populateNonPrimitiveField(root, field, def);
                continue;
            }
            if (value instanceof List) {
                for (Object e : (List)value) {
                    if (DefaultSubstitutor.typeFor(e.getClass()) != null) continue;
                    DefaultSubstitutor.applyDefaults(e);
                }
                continue;
            }
            if (DefaultSubstitutor.typeFor(value.getClass()) != null) continue;
            DefaultSubstitutor.applyDefaults(value);
        }
    }

    private static void populateNonPrimitiveField(Object obj, Field field, String def) {
        Class<?> fieldType = field.getType();
        Field valueField = DefaultSubstitutor.valueFieldFor(fieldType);
        Type type = DefaultSubstitutor.typeFor(valueField.getType());
        if (type == null) {
            throw new RuntimeException("Cannot handle non-primitive value field: " + valueField);
        }
        Object value = DefaultSubstitutor.newInstanceWithDefaults(fieldType);
        field.setAccessible(true);
        valueField.setAccessible(true);
        try {
            valueField.set(value, type.valueFor(def));
            field.set(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new TCConfigurationSetupException(e);
        }
    }

    private static <T> T newInstanceWithDefaults(Class<T> type) {
        T instance;
        try {
            instance = type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        DefaultSubstitutor.applyDefaults(instance);
        return instance;
    }

    private static Field valueFieldFor(Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            XmlValue[] xmlValues = (XmlValue[])field.getDeclaredAnnotationsByType(XmlValue.class);
            if (xmlValues == null || xmlValues.length < 1) continue;
            return field;
        }
        throw new TCConfigurationSetupException("Expecting to find " + XmlValue.class.getName() + " present on a field of " + type);
    }

    private static void setField(Object obj, Field field, Type type, String value) {
        try {
            field.setAccessible(true);
            field.set(obj, type.valueFor(value));
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDefaultFor(Field field) {
        for (XmlElement xmlElement : (XmlElement[])field.getDeclaredAnnotationsByType(XmlElement.class)) {
            String def = xmlElement.defaultValue();
            if (def == null || def.equals("\u0000")) continue;
            return def;
        }
        return null;
    }

    private static Field fieldFor(Method method) {
        String fieldName = method.getReturnType() == Boolean.class ? method.getName().replaceFirst("is", "") : method.getName().replaceFirst("get", "");
        fieldName = Introspector.decapitalize(fieldName);
        try {
            return method.getDeclaringClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new TCConfigurationSetupException(method.toString(), e);
        }
    }

    private static Object methodInvoke(Object obj, Method method) {
        if (method.getParameterTypes().length != 0) {
            throw new RuntimeException("Expecting zero arg method: " + method);
        }
        try {
            return method.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new TCConfigurationSetupException(method.getDeclaringClass().getName() + ":" + method.getName(), e);
        }
    }

    private static Type typeFor(Class<?> type) {
        for (Type t : Type.values()) {
            if (!t.matches(type)) continue;
            return t;
        }
        return null;
    }

    private static enum Type {
        BOOLEAN((Class)Boolean.class, (Class)Boolean.TYPE){

            @Override
            Object valueFor(String value) {
                return Boolean.valueOf(value);
            }
        }
        ,
        BYTE((Class)Byte.class, (Class)Byte.TYPE){

            @Override
            Object valueFor(String value) {
                return Byte.valueOf(value);
            }
        }
        ,
        CHARACTER((Class)Character.class, (Class)Character.TYPE){

            @Override
            Object valueFor(String value) {
                if (value.length() != 1) {
                    throw new RuntimeException("invalid char: " + value);
                }
                return Character.valueOf(value.charAt(0));
            }
        }
        ,
        DOUBLE((Class)Double.class, (Class)Double.TYPE){

            @Override
            Object valueFor(String value) {
                return Double.valueOf(value);
            }
        }
        ,
        FLOAT((Class)Float.class, (Class)Float.TYPE){

            @Override
            Object valueFor(String value) {
                return Float.valueOf(value);
            }
        }
        ,
        INT((Class)Integer.class, (Class)Integer.TYPE){

            @Override
            Object valueFor(String value) {
                return Integer.valueOf(value);
            }
        }
        ,
        LONG((Class)Long.class, (Class)Long.TYPE){

            @Override
            Object valueFor(String value) {
                return Long.valueOf(value);
            }
        }
        ,
        SHORT((Class)Short.class, (Class)Short.TYPE){

            @Override
            Object valueFor(String value) {
                return Short.valueOf(value);
            }
        }
        ,
        STRING((Class)String.class, (Class)String.class){

            @Override
            Object valueFor(String value) {
                return value;
            }
        };

        private final Class<?> type1;
        private final Class<?> type2;

        private Type(Class<?> type1, Class<?> type2) {
            this.type1 = type1;
            this.type2 = type2;
        }

        abstract Object valueFor(String var1);

        boolean matches(Class<?> t) {
            return this.type1 == t || this.type2 == t;
        }
    }
}

