/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.config.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ParameterSubstitutor {
    private static String uniqueTempDirectory = null;

    public static String substitute(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        char[] sourceChars = source.toCharArray();
        for (int i = 0; i < sourceChars.length; ++i) {
            if (sourceChars[i] == '%') {
                char nextChar = sourceChars[++i];
                String value = "" + nextChar;
                switch (nextChar) {
                    case 'd': {
                        value = ParameterSubstitutor.getUniqueTempDirectory();
                        break;
                    }
                    case 'D': {
                        value = ParameterSubstitutor.getDatestamp();
                        break;
                    }
                    case 'h': {
                        value = ParameterSubstitutor.getHostName();
                        break;
                    }
                    case 'c': {
                        value = ParameterSubstitutor.getCanonicalHostName();
                        break;
                    }
                    case 'i': {
                        value = ParameterSubstitutor.getIpAddress();
                        break;
                    }
                    case 'H': {
                        value = System.getProperty("user.home");
                        break;
                    }
                    case 'n': {
                        value = System.getProperty("user.name");
                        break;
                    }
                    case 'o': {
                        value = System.getProperty("os.name");
                        break;
                    }
                    case 'a': {
                        value = System.getProperty("os.arch");
                        break;
                    }
                    case 'v': {
                        value = System.getProperty("os.version");
                        break;
                    }
                    case 't': {
                        value = System.getProperty("java.io.tmpdir");
                        break;
                    }
                    case '(': {
                        StringBuilder propertyName = new StringBuilder();
                        boolean foundEnd = false;
                        while (++i < sourceChars.length) {
                            if (sourceChars[i] == ')') {
                                foundEnd = true;
                                break;
                            }
                            propertyName.append(sourceChars[i]);
                        }
                        if (foundEnd) {
                            String prop = propertyName.toString();
                            String defaultValue = "%(" + prop + ")";
                            int index = prop.lastIndexOf(":");
                            if (index > 0) {
                                prop = prop.substring(0, index);
                                defaultValue = prop.substring(index + 1);
                            }
                            if ((value = System.getProperty(prop)) != null) break;
                            value = defaultValue;
                            break;
                        }
                        value = "%(" + propertyName.toString();
                        break;
                    }
                    default: {
                        value = "%" + nextChar;
                    }
                }
                out.append(value);
                continue;
            }
            out.append(sourceChars[i]);
        }
        return out.toString();
    }

    private static synchronized String getUniqueTempDirectory() {
        if (uniqueTempDirectory == null) {
            try {
                File theFile = File.createTempFile("terracotta", "data");
                theFile.delete();
                uniqueTempDirectory = !theFile.mkdir() ? System.getProperty("java.io.tmpdir") : theFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                uniqueTempDirectory = System.getProperty("java.io.tmpdir");
            }
        }
        return uniqueTempDirectory;
    }

    private static synchronized String getDatestamp() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return format.format(new Date(System.currentTimeMillis()));
    }

    public static String getCanonicalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            throw new RuntimeException(uhe);
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            throw new RuntimeException(uhe);
        }
    }

    public static String getIpAddress() {
        try {
            InetAddress address;
            try {
                address = InetAddress.getLocalHost();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                address = InetAddress.getByName(null);
            }
            return address.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            throw new RuntimeException(uhe);
        }
    }
}

