/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.lock;

import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class LockMessaging {
    private static final MessageCodec<LockOperation, LockTransition> CODEC = new MessageCodec<LockOperation, LockTransition>(){

        public byte[] encodeMessage(LockOperation message) throws MessageCodecException {
            return new byte[]{(byte)message.getOperation().ordinal(), (byte)message.getHoldType().ordinal()};
        }

        public LockOperation decodeMessage(byte[] bytes) throws MessageCodecException {
            return new LockOperation(Operation.values()[bytes[0]], HoldType.values()[bytes[1]]);
        }

        public byte[] encodeResponse(LockTransition response) throws MessageCodecException {
            if (response.isAcquired()) {
                return new byte[]{0};
            }
            if (response.isReleased()) {
                return new byte[]{1};
            }
            return new byte[]{2};
        }

        public LockTransition decodeResponse(byte[] bytes) throws MessageCodecException {
            switch (bytes[0]) {
                case 0: {
                    return new LockTransition(true, false);
                }
                case 1: {
                    return new LockTransition(false, true);
                }
                case 2: {
                    return new LockTransition(false, false);
                }
            }
            throw new MessageCodecException("Unexpected transition encoding", null);
        }
    };

    public static MessageCodec<LockOperation, LockTransition> codec() {
        return CODEC;
    }

    public static LockOperation tryLock(HoldType type) {
        return new LockOperation(Operation.TRY_ACQUIRE, type);
    }

    public static LockOperation lock(HoldType type) {
        return new LockOperation(Operation.ACQUIRE, type);
    }

    public static LockOperation unlock(HoldType type) {
        return new LockOperation(Operation.RELEASE, type);
    }

    public static LockTransition acquired() {
        return new LockTransition(true, false);
    }

    public static LockTransition released() {
        return new LockTransition(false, true);
    }

    public static LockTransition empty() {
        return new LockTransition(false, false);
    }

    public static enum Operation {
        ACQUIRE,
        TRY_ACQUIRE,
        RELEASE;

    }

    public static enum HoldType {
        WRITE,
        READ;

    }

    public static class LockTransition
    implements EntityResponse {
        private final boolean acquired;
        private final boolean released;

        private LockTransition(boolean acquired, boolean released) {
            this.acquired = acquired;
            this.released = released;
        }

        public boolean isAcquired() {
            return this.acquired;
        }

        public boolean isReleased() {
            return this.released;
        }
    }

    public static class LockOperation
    implements EntityMessage {
        private final Operation operation;
        private final HoldType type;

        LockOperation(Operation operation, HoldType type) {
            this.operation = operation;
            this.type = type;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public HoldType getHoldType() {
            return this.type;
        }
    }
}

