/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.ConfigCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.PrimitiveDecodingSupport;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.PrimitiveEncodingSupport;
import org.terracotta.runnel.encoding.StructEncoder;

public class LifeCycleMessageCodec {
    private static final String CONFIG_PRESENT_FIELD = "configPresent";
    private final StructBuilder VALIDATE_MESSAGE_STRUCT_BUILDER_PREFIX = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).bool("configPresent", 30);
    private static final int CONFIGURE_MESSAGE_NEXT_INDEX = 40;
    private final StructBuilder VALIDATE_STORE_MESSAGE_STRUCT_BUILDER_PREFIX = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30);
    private static final int VALIDATE_STORE_NEXT_INDEX = 40;
    private final Struct PREPARE_FOR_DESTROY_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).build();
    private final Struct validateMessageStruct;
    private final Struct validateStoreMessageStruct;
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();
    private final ConfigCodec configCodec;

    public LifeCycleMessageCodec(ConfigCodec configCodec) {
        this.configCodec = configCodec;
        this.validateMessageStruct = this.configCodec.injectServerSideConfiguration(this.VALIDATE_MESSAGE_STRUCT_BUILDER_PREFIX, 40).getUpdatedBuilder().build();
        this.validateStoreMessageStruct = this.configCodec.injectServerStoreConfiguration(this.VALIDATE_STORE_MESSAGE_STRUCT_BUILDER_PREFIX, 40).getUpdatedBuilder().build();
    }

    public byte[] encode(LifecycleMessage message) {
        switch (message.getMessageType()) {
            case VALIDATE: {
                return this.encodeTierManagerValidateMessage((LifecycleMessage.ValidateStoreManager)message);
            }
            case VALIDATE_SERVER_STORE: {
                return this.encodeValidateStoreMessage((LifecycleMessage.ValidateServerStore)message);
            }
            case PREPARE_FOR_DESTROY: {
                return this.encodePrepareForDestroyMessage(message);
            }
        }
        throw new IllegalArgumentException("Unknown lifecycle message: " + message.getClass());
    }

    private byte[] encodePrepareForDestroyMessage(LifecycleMessage message) {
        return this.PREPARE_FOR_DESTROY_STRUCT.encoder().enm("opCode", (Object)message.getMessageType()).encode().array();
    }

    private byte[] encodeValidateStoreMessage(LifecycleMessage.ValidateServerStore message) {
        StructEncoder encoder = this.validateStoreMessageStruct.encoder();
        this.messageCodecUtils.encodeMandatoryFields((StructEncoder<Void>)encoder, message);
        encoder.string("serverStoreName", message.getName());
        this.configCodec.encodeServerStoreConfiguration((PrimitiveEncodingSupport<?>)encoder, message.getStoreConfiguration());
        return encoder.encode().array();
    }

    private byte[] encodeTierManagerValidateMessage(LifecycleMessage.ValidateStoreManager message) {
        StructEncoder encoder = this.validateMessageStruct.encoder();
        ServerSideConfiguration config = message.getConfiguration();
        this.messageCodecUtils.encodeMandatoryFields((StructEncoder<Void>)encoder, message);
        if (config == null) {
            encoder.bool(CONFIG_PRESENT_FIELD, false);
        } else {
            encoder.bool(CONFIG_PRESENT_FIELD, true);
            this.configCodec.encodeServerSideConfiguration(encoder, config);
        }
        return encoder.encode().array();
    }

    public EhcacheEntityMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case VALIDATE: {
                return this.decodeValidateMessage(messageBuffer);
            }
            case VALIDATE_SERVER_STORE: {
                return this.decodeValidateServerStoreMessage(messageBuffer);
            }
            case PREPARE_FOR_DESTROY: {
                return this.decodePrepareForDestroyMessage();
            }
        }
        throw new IllegalArgumentException("LifeCycleMessage operation not defined for : " + (Object)((Object)messageType));
    }

    private LifecycleMessage.PrepareForDestroy decodePrepareForDestroyMessage() {
        return new LifecycleMessage.PrepareForDestroy();
    }

    private LifecycleMessage.ValidateServerStore decodeValidateServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = this.validateStoreMessageStruct.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID((StructDecoder<Void>)decoder);
        String storeName = decoder.string("serverStoreName");
        ServerStoreConfiguration config = this.configCodec.decodeServerStoreConfiguration((PrimitiveDecodingSupport)decoder);
        LifecycleMessage.ValidateServerStore message = new LifecycleMessage.ValidateServerStore(storeName, config, cliendId);
        message.setId(msgId);
        return message;
    }

    private LifecycleMessage.ValidateStoreManager decodeValidateMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = this.validateMessageStruct.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID cliendId = this.messageCodecUtils.decodeUUID((StructDecoder<Void>)decoder);
        boolean configPresent = decoder.bool(CONFIG_PRESENT_FIELD);
        ServerSideConfiguration config = null;
        if (configPresent) {
            config = this.configCodec.decodeServerSideConfiguration(decoder);
        }
        LifecycleMessage.ValidateStoreManager message = new LifecycleMessage.ValidateStoreManager(config, cliendId);
        if (msgId != null) {
            message.setId(msgId);
        }
        return message;
    }
}

