/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.ClusterTierManagerReconnectMessage;
import org.ehcache.clustered.common.internal.messages.ClusterTierReconnectMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.ArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.ArrayEncoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class ReconnectMessageCodec {
    private static final String HASH_INVALIDATION_IN_PROGRESS_FIELD = "hashInvalidationInProgress";
    private static final String CLEAR_IN_PROGRESS_FIELD = "clearInProgress";
    private static final Struct CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT = StructBuilder.newStructBuilder().int64("msbUUID", 10).int64("lsbUUID", 11).int64s("hashInvalidationInProgress", 20).bool("clearInProgress", 30).build();
    private static final Struct RECONNECT_MESSAGE_STRUCT = StructBuilder.newStructBuilder().int64("msbUUID", 10).int64("lsbUUID", 11).build();
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();

    public byte[] encode(ClusterTierReconnectMessage reconnectMessage) {
        StructEncoder encoder = CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT.encoder().int64("msbUUID", reconnectMessage.getClientId().getMostSignificantBits()).int64("lsbUUID", reconnectMessage.getClientId().getLeastSignificantBits());
        ArrayEncoder arrayEncoder = encoder.int64s(HASH_INVALIDATION_IN_PROGRESS_FIELD);
        for (Long hash : reconnectMessage.getInvalidationsInProgress()) {
            arrayEncoder.value((Object)hash);
        }
        encoder.bool(CLEAR_IN_PROGRESS_FIELD, reconnectMessage.isClearInProgress());
        return encoder.encode().array();
    }

    public byte[] encode(ClusterTierManagerReconnectMessage reconnectMessage) {
        return CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT.encoder().int64("msbUUID", reconnectMessage.getClientId().getMostSignificantBits()).int64("lsbUUID", reconnectMessage.getClientId().getLeastSignificantBits()).encode().array();
    }

    public ClusterTierManagerReconnectMessage decodeReconnectMessage(byte[] payload) {
        return new ClusterTierManagerReconnectMessage(this.messageCodecUtils.decodeUUID((StructDecoder<Void>)RECONNECT_MESSAGE_STRUCT.decoder(ByteBuffer.wrap(payload))));
    }

    public ClusterTierReconnectMessage decode(byte[] payload) {
        StructDecoder decoder = CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT.decoder(ByteBuffer.wrap(payload));
        UUID clientId = this.messageCodecUtils.decodeUUID((StructDecoder<Void>)decoder);
        ArrayDecoder arrayDecoder = decoder.int64s(HASH_INVALIDATION_IN_PROGRESS_FIELD);
        HashSet<Long> hashes = new HashSet<Long>();
        if (arrayDecoder != null) {
            for (int i = 0; i < arrayDecoder.length(); ++i) {
                hashes.add((Long)arrayDecoder.value());
            }
        }
        Boolean clearInProgress = decoder.bool(CLEAR_IN_PROGRESS_FIELD);
        ClusterTierReconnectMessage message = new ClusterTierReconnectMessage(clientId);
        message.addInvalidationsInProgress(hashes);
        if (clearInProgress != null && clearInProgress.booleanValue()) {
            message.clearInProgress();
        }
        return message;
    }
}

