/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;

public class ServerStoreMessageFactory {
    private final UUID clientId;

    public ServerStoreMessageFactory(UUID clientId) {
        this.clientId = clientId;
    }

    public ServerStoreOpMessage.GetMessage getOperation(long key) {
        return new ServerStoreOpMessage.GetMessage(key);
    }

    public ServerStoreOpMessage.GetAndAppendMessage getAndAppendOperation(long key, ByteBuffer payload) {
        return new ServerStoreOpMessage.GetAndAppendMessage(key, payload, this.clientId);
    }

    public ServerStoreOpMessage.AppendMessage appendOperation(long key, ByteBuffer payload) {
        return new ServerStoreOpMessage.AppendMessage(key, payload, this.clientId);
    }

    public ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadOperation(long key, Chain expect, Chain update) {
        return new ServerStoreOpMessage.ReplaceAtHeadMessage(key, expect, update, this.clientId);
    }

    public ServerStoreOpMessage.ClientInvalidationAck clientInvalidationAck(long key, int invalidationId) {
        return new ServerStoreOpMessage.ClientInvalidationAck(key, invalidationId);
    }

    public ServerStoreOpMessage.ClientInvalidationAllAck clientInvalidationAllAck(int invalidationId) {
        return new ServerStoreOpMessage.ClientInvalidationAllAck(invalidationId);
    }

    public ServerStoreOpMessage.ClearMessage clearOperation() {
        return new ServerStoreOpMessage.ClearMessage(this.clientId);
    }
}

