/*
 * Decompiled with CFR 0.152.
 */
package com.tc.admin.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.swing.SwingUtilities;

public class MBeanServerInvocationProxy
extends MBeanServerInvocationHandler {
    private static final boolean REPORT_VIOLATORS = false;

    public MBeanServerInvocationProxy(MBeanServerConnection connection, ObjectName objectName) {
        super(connection, objectName);
    }

    public static <T> T newMBeanProxy(MBeanServerConnection connection, ObjectName objectName, Class<T> interfaceClass, boolean notificationBroadcaster) {
        MBeanServerInvocationProxy handler = new MBeanServerInvocationProxy(connection, objectName);
        Class[] interfaces = notificationBroadcaster ? new Class[]{interfaceClass, NotificationEmitter.class} : new Class[]{interfaceClass};
        Object proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), interfaces, (InvocationHandler)handler);
        return interfaceClass.cast(proxy);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (MBeanServerInvocationProxy.reportViolators() && SwingUtilities.isEventDispatchThread()) {
            new Exception("MBean invoked in Swing event dispatch thread").printStackTrace();
        }
        return super.invoke(proxy, method, args);
    }

    private static boolean reportViolators() {
        return false;
    }
}

