/*
 * Decompiled with CFR 0.152.
 */
package com.tc.classloader;

import com.tc.classloader.CommonComponentChecker;
import java.net.URL;
import java.net.URLClassLoader;

public class ComponentURLClassLoader
extends URLClassLoader {
    private final CommonComponentChecker commonComponentChecker;

    public ComponentURLClassLoader(URL[] urls, ClassLoader parent, CommonComponentChecker commonComponentChecker) {
        super(urls, parent);
        this.commonComponentChecker = commonComponentChecker;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> target = this.findLoadedClass(name);
        if (target == null && !this.commonComponentChecker.check(target = super.loadClass(name, resolve))) {
            try {
                target = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (resolve) {
            this.resolveClass(target);
        }
        return target;
    }
}

