/*
 * Decompiled with CFR 0.152.
 */
package com.tc.classloader;

import com.tc.classloader.AnnotationOrDirectoryStrategyChecker;
import com.tc.classloader.ApiClassLoader;
import com.tc.classloader.ComponentURLClassLoader;
import com.tc.config.Directories;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceLocator {
    private static final TCLogger LOG = TCLogging.getLogger(ServiceLocator.class);
    private static final String METAINFCONST = "META-INF/services/";
    private static final Map<ClassLoader, ApiClassLoader> API_LOADERS;
    public static ClassLoader PLATFORM_LOADER;

    public static Map<String, String> discoverImplementations(ClassLoader loader, String interfaceName) {
        try {
            HashMap<String, String> urls = new HashMap<String, String>();
            Enumeration<URL> urlEnumeration = loader.getResources(METAINFCONST + interfaceName);
            StringBuilder sb = new StringBuilder();
            while (urlEnumeration.hasMoreElements()) {
                String[] splits;
                int i;
                URL x = urlEnumeration.nextElement();
                InputStream s = x.openStream();
                while ((i = s.read()) != -1) {
                    sb.append((char)i);
                }
                s.close();
                for (String split : splits = sb.toString().split("\n")) {
                    String trim = split.replaceAll("\n", "").trim();
                    if (split.startsWith("#") || trim.isEmpty()) continue;
                    String urlString = x.toExternalForm();
                    urlString = urlString.startsWith("jar:") ? urlString.substring(4, urlString.indexOf("!")) : urlString.substring(0, urlString.indexOf(METAINFCONST));
                    urls.put(trim, urlString);
                }
                sb.setLength(0);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The list of implementation to URL to find them is " + urls.toString()));
            }
            return urls;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<Class<? extends T>> getImplementations(Class<T> interfaceClass) {
        return ServiceLocator.getImplementations(interfaceClass, Thread.currentThread().getContextClassLoader());
    }

    public static <T> List<Class<? extends T>> getImplementations(final Class<T> interfaceClass, ClassLoader parent) {
        final List<Class<?>> items = ServiceLocator.getImplementations(interfaceClass.getName(), parent);
        return new AbstractList<Class<? extends T>>(){

            @Override
            public Class<? extends T> get(int index) {
                Class got = (Class)items.get(index);
                try {
                    return got.asSubclass(interfaceClass);
                }
                catch (ClassCastException cast) {
                    ClassLoader loader = interfaceClass.getClassLoader();
                    ClassLoader sub = got.getInterfaces()[0].getClassLoader();
                    LOG.warn((Object)("There has been a class cast exception.  This is usually an indication that a service has been improperly packaged with system dependencies included.  Offending class is " + interfaceClass.getName()));
                    throw cast;
                }
            }

            @Override
            public int size() {
                return items.size();
            }
        };
    }

    private static List<Class<?>> getImplementations(String interfaceName, ClassLoader parent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Discovering " + interfaceName + " with parent classloader " + parent.getClass().getName()));
        }
        ApiClassLoader apiLoader = ServiceLocator.getApiClassLoader(parent);
        Map<String, String> urls = ServiceLocator.discoverImplementations(apiLoader, interfaceName);
        ArrayList implementations = new ArrayList();
        if (null == urls || urls.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No implementations found for " + interfaceName));
            }
            return implementations;
        }
        for (Map.Entry<String, String> entry : urls.entrySet()) {
            try {
                ComponentURLClassLoader loader = new ComponentURLClassLoader(new URL[]{new URL(entry.getValue())}, (ClassLoader)ServiceLocator.getApiClassLoader(parent), new AnnotationOrDirectoryStrategyChecker());
                implementations.add(Class.forName(entry.getKey(), false, loader));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return implementations;
    }

    private static synchronized ApiClassLoader getApiClassLoader(ClassLoader parent) {
        ClassLoader chainCheck;
        for (chainCheck = parent; chainCheck != null; chainCheck = chainCheck.getParent()) {
            if (!(chainCheck instanceof ApiClassLoader)) continue;
            return (ApiClassLoader)chainCheck;
        }
        chainCheck = parent;
        while (chainCheck instanceof ComponentURLClassLoader) {
            chainCheck = chainCheck.getParent();
        }
        if (chainCheck == null) {
            chainCheck = ClassLoader.getSystemClassLoader();
        }
        LOG.warn((Object)("storing a new API class loader for parent " + chainCheck));
        ApiClassLoader loader = API_LOADERS.get(chainCheck);
        if (loader == null) {
            loader = ServiceLocator.createApiClassLoader(chainCheck);
            API_LOADERS.put(chainCheck, loader);
        }
        return loader;
    }

    private static boolean fileFilter(File target) {
        String name = target.getName().toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".zip");
    }

    private static URL toURL(File uri) {
        try {
            return uri.toURI().toURL();
        }
        catch (MalformedURLException mal) {
            return null;
        }
    }

    private static URL[] createURLS(File plugins) throws FileNotFoundException {
        if (plugins.exists()) {
            return (URL[])Arrays.stream(plugins.listFiles()).filter(ServiceLocator::fileFilter).map(ServiceLocator::toURL).filter(u -> u != null).toArray(URL[]::new);
        }
        return new URL[0];
    }

    public static URL[] findPluginURLS() throws FileNotFoundException {
        return ServiceLocator.createURLS(Directories.getServerPluginsLibDir());
    }

    public static ClassLoader getPlatformLoader() {
        return PLATFORM_LOADER;
    }

    private static ClassLoader createPlatformClassLoader() {
        try {
            URLClassLoader purls = new URLClassLoader(ServiceLocator.findPluginURLS());
            ApiClassLoader apis = ServiceLocator.createApiClassLoader(purls);
            return apis;
        }
        catch (FileNotFoundException file) {
            return ClassLoader.getSystemClassLoader();
        }
    }

    private static ApiClassLoader createApiClassLoader(ClassLoader parent) {
        try {
            return new ApiClassLoader(ServiceLocator.createURLS(Directories.getServerPluginsApiDir()), parent);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            LOG.info((Object)("Entity/Service apis will be loaded from " + Directories.getServerPluginsApiDir().getAbsolutePath()));
            LOG.info((Object)("Entity/Service implementations will be loaded from " + Directories.getServerPluginsLibDir().getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        API_LOADERS = new HashMap<ClassLoader, ApiClassLoader>();
        PLATFORM_LOADER = ServiceLocator.createPlatformClassLoader();
    }
}

