/*
 * Decompiled with CFR 0.152.
 */
package com.tc.cli;

import com.tc.management.JMXConnectorProxy;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.remote.JMXConnector;
import jline.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public class CommandLineBuilder {
    private Options options = new Options();
    private final String callingClassName;
    private final String[] cmdArguments;
    private CommandLine commandLine;
    private String usageMessage;

    public CommandLineBuilder(String callingClassName, String[] cmdArguments) {
        this.callingClassName = callingClassName;
        this.cmdArguments = Arrays.asList(cmdArguments).toArray(new String[0]);
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setUsageMessage(String message) {
        this.usageMessage = message;
    }

    public void addOption(String opt, String longOpt, boolean hasArg, String description, Class<?> type, boolean isRequired) {
        Option option = new Option(opt, longOpt, hasArg, description);
        option.setType(type);
        option.setRequired(isRequired);
        this.options.addOption(option);
    }

    public void addOption(String opt, String description, Class<?> type, boolean isRequired) {
        Option option = new Option(opt, description);
        option.setType(type);
        option.setRequired(isRequired);
        this.options.addOption(option);
    }

    public void addOption(String opt, boolean hasArg, String description, Class<?> type, boolean isRequired) {
        Option option = new Option(opt, hasArg, description);
        option.setType(type);
        option.setRequired(isRequired);
        this.options.addOption(option);
    }

    public void addOption(String opt, String longOpt, boolean hasArg, String description, Class<?> type, boolean isRequired, String argName) {
        Option option = new Option(opt, longOpt, hasArg, description);
        option.setType(type);
        option.setRequired(isRequired);
        option.setArgName(argName);
        this.options.addOption(option);
    }

    public void addOption(String opt, String description, Class<?> type, boolean isRequired, String argName) {
        Option option = new Option(opt, description);
        option.setType(type);
        option.setRequired(isRequired);
        option.setArgName(argName);
        this.options.addOption(option);
    }

    public void addOption(String opt, boolean hasArg, String description, Class<?> type, boolean isRequired, String argName) {
        Option option = new Option(opt, hasArg, description);
        option.setType(type);
        option.setRequired(isRequired);
        option.setArgName(argName);
        this.options.addOption(option);
    }

    public String[] getArguments() {
        return this.commandLine.getArgs();
    }

    public String[] getUnparsedArgs() {
        return this.cmdArguments;
    }

    public void parse() {
        try {
            this.commandLine = new GnuParser().parse(this.options, this.cmdArguments);
        }
        catch (UnrecognizedOptionException e) {
            System.err.println(e.getMessage());
            this.usageAndDie();
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.usageAndDie();
        }
    }

    public void usageAndDie() {
        String message = this.usageMessage != null ? this.usageMessage : "java " + this.callingClassName;
        new HelpFormatter().printHelp(message, this.options);
        System.exit(1);
    }

    public void usageAndDie(String message) {
        new HelpFormatter().printHelp(message, this.options);
        System.exit(1);
    }

    public void printArguments() {
        System.err.println("Arguments are: " + Arrays.asList(this.commandLine.getArgs()));
    }

    public boolean hasOption(char arg) {
        return this.commandLine.hasOption(arg);
    }

    public boolean hasOption(String arg) {
        return this.commandLine.hasOption(arg);
    }

    public String getOptionValue(char arg) {
        return this.commandLine.getOptionValue(arg);
    }

    public String getOptionValue(String arg) {
        return this.commandLine.getOptionValue(arg);
    }

    public static String readPassword() {
        try {
            System.out.print("Enter password: ");
            return new ConsoleReader().readLine(Character.valueOf('*'));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JMXConnector getJMXConnector(String host, int port) {
        return new JMXConnectorProxy(host, port);
    }

    public static JMXConnector getJMXConnector(String username, String password, String host, int port) {
        return CommandLineBuilder.getJMXConnector(username, password, host, port, false);
    }

    public static JMXConnector getJMXConnector(String username, String password, String host, int port, boolean secured) {
        HashMap<String, Object[]> env = new HashMap<String, Object[]>();
        if (username != null && password != null) {
            if (secured) {
                Object[] creds = new Object[]{username, password.toCharArray()};
                env.put("jmx.remote.credentials", creds);
            } else {
                String[] creds = new String[]{username, password};
                env.put("jmx.remote.credentials", creds);
            }
        }
        return new JMXConnectorProxy(host, port, env, secured);
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }
}

