/*
 * Decompiled with CFR 0.152.
 */
package com.tc.cli;

import com.tc.cli.command.BaseCommand;
import com.tc.cli.command.Command;
import com.tc.util.ProductInfo;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CommandLineMain {
    private Writer writer;
    private final Map<String, Command> commands = new HashMap<String, Command>();
    private final HelpCommand helpCommand;

    public CommandLineMain() {
        this(new OutputStreamWriter(System.out));
    }

    CommandLineMain(Writer writer) {
        this.writer = writer;
        this.initialize();
        this.helpCommand = new HelpCommand(this.commands, writer);
    }

    private void initialize() {
    }

    void registerCommand(Command command) {
        this.commands.put(command.optionName(), command);
    }

    public void executeCommand(String commandName, String[] args) {
        if (commandName.equals(this.helpCommand.optionName())) {
            this.helpCommand.execute(args);
        } else {
            Command command = this.commands.get(commandName);
            if (command == null) {
                this.println("not a valid command: " + commandName);
            } else {
                command.execute(args);
            }
        }
    }

    private void println(String message) {
        try {
            this.writer.write(message);
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.writer = new OutputStreamWriter(System.out);
        }
    }

    public void printUsage() {
        this.println("Type 'help' for usage.");
    }

    public static void main(String[] args) {
        CommandLineMain commandLineMain = new CommandLineMain();
        if (args.length < 1) {
            commandLineMain.printUsage();
            System.exit(1);
        }
        String commandName = args[0];
        String[] commandArgs = new String[]{};
        if (args.length > 1) {
            commandArgs = Arrays.asList(args).subList(1, args.length).toArray(new String[0]);
        }
        commandLineMain.executeCommand(commandName, commandArgs);
    }

    private static final class HelpCommand
    extends BaseCommand {
        private final Map<String, Command> commands;

        public HelpCommand(Map<String, Command> commands, Writer writer) {
            super(writer);
            this.commands = commands;
        }

        @Override
        public String description() {
            return "command lists all the commands available on the Terracotta command-line utility";
        }

        @Override
        public void execute(String[] args) {
            this.println("Usage: <command> [args]");
            this.println("Terracotta command-line utility, version " + ProductInfo.getInstance().version());
            this.println("Type 'help <command>' for help on a specific command.");
            this.println("\n");
            if (args.length > 0) {
                String commandName = args[0];
                Command command = this.commands.get(commandName);
                if (command != null) {
                    this.println(command.name() + "\n");
                    command.printUsage();
                    this.println("\n\n");
                } else {
                    this.println("invalid command: " + commandName);
                }
            } else {
                this.println("Available commands:");
                for (Command command : this.commands.values()) {
                    this.println("\t\t " + command.optionName());
                }
                this.println("\n");
                for (Command command : this.commands.values()) {
                    this.println(command.name() + "\n");
                    command.printUsage();
                    this.println("\n\n");
                }
            }
        }

        @Override
        public String name() {
            return "Help";
        }

        @Override
        public String optionName() {
            return "help";
        }

        @Override
        public void printUsage() {
            this.println("");
        }
    }
}

