/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config;

import com.tc.config.HaConfig;
import com.tc.config.NodesStore;
import com.tc.config.NodesStoreImpl;
import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.net.groups.Node;
import com.tc.net.groups.ServerGroup;
import com.tc.object.config.schema.L2Config;
import com.tc.util.Assert;
import java.util.HashSet;
import java.util.Set;

public class HaConfigImpl
implements HaConfig {
    private final L2ConfigurationSetupManager configSetupManager;
    private final NodesStoreImpl nodeStore;
    private final Node thisNode;
    private final ServerGroup thisGroup;

    public HaConfigImpl(L2ConfigurationSetupManager configSetupManager) {
        this.configSetupManager = configSetupManager;
        ActiveServerGroupConfig groupsConfig = this.configSetupManager.getActiveServerGroupForThisL2();
        this.thisGroup = new ServerGroup(groupsConfig);
        Set<Node> nodes = this.makeAllNodes();
        this.thisNode = this.makeThisNode();
        this.nodeStore = new NodesStoreImpl(nodes, this.getNodeNamesForThisGroup(), configSetupManager);
    }

    private Set<String> getNodeNamesForThisGroup() {
        HashSet<String> tmpSet = new HashSet<String>();
        for (Node n : this.thisGroup.getNodes()) {
            tmpSet.add(n.getServerNodeName());
        }
        return tmpSet;
    }

    private Set<Node> makeAllNodes() {
        String[] l2Names;
        HashSet<Node> allClusterNodes = new HashSet<Node>();
        ActiveServerGroupConfig asgc = this.configSetupManager.getActiveServerGroupForThisL2();
        Assert.assertNotNull((Object)asgc);
        for (String l2Name : l2Names = asgc.getMembers()) {
            try {
                L2Config l2 = this.configSetupManager.dsoL2ConfigFor(l2Name);
                Node node = HaConfigImpl.makeNode(l2);
                allClusterNodes.add(node);
                this.addNodeToGroup(node, l2Name);
            }
            catch (ConfigurationSetupException e) {
                throw new RuntimeException("Error getting l2 config for: " + l2Name, e);
            }
        }
        return allClusterNodes;
    }

    private void addNodeToGroup(Node node, String serverName) {
        boolean added = false;
        if (this.thisGroup.hasMember(serverName)) {
            this.thisGroup.addNode(node, serverName);
            added = true;
        }
        if (!added) {
            throw new AssertionError((Object)("Node=[" + node + "] with serverName=[" + serverName + "] was not added to any group!"));
        }
    }

    @Override
    public Node getThisNode() {
        return this.thisNode;
    }

    private Node makeThisNode() {
        L2Config l2 = this.configSetupManager.dsoL2Config();
        return HaConfigImpl.makeNode(l2);
    }

    public static Node makeNode(L2Config l2) {
        String host = l2.tsaGroupPort().getBind();
        if ("0.0.0.0".equals(host)) {
            host = l2.host();
        }
        return new Node(host, l2.tsaPort().getValue(), l2.tsaGroupPort().getValue());
    }

    @Override
    public NodesStore getNodesStore() {
        return this.nodeStore;
    }
}

