/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config;

import com.tc.config.NodesStore;
import com.tc.config.ReloadConfigChangeContext;
import com.tc.config.TopologyChangeListener;
import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.net.groups.Node;
import com.tc.object.config.schema.L2Config;
import com.tc.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class NodesStoreImpl
implements NodesStore,
TopologyChangeListener {
    private final Set<Node> nodes;
    private final CopyOnWriteArraySet<TopologyChangeListener> listeners = new CopyOnWriteArraySet();
    private L2ConfigurationSetupManager configSetupManager;
    private volatile Set<String> nodeNamesForThisGroup = new HashSet<String>();
    private volatile Map<String, String> nodeNamesToServerNames = new HashMap<String, String>();

    public NodesStoreImpl(Set<Node> nodes) {
        this.nodes = Collections.synchronizedSet(nodes);
    }

    public NodesStoreImpl(Set<Node> nodes, Set<String> nodeNamesForThisGroup, L2ConfigurationSetupManager configSetupManager) {
        this(nodes);
        this.nodeNamesForThisGroup.addAll(nodeNamesForThisGroup);
        this.configSetupManager = configSetupManager;
        this.initNodeNamesToServerNames();
    }

    @Override
    public void topologyChanged(ReloadConfigChangeContext context) {
        this.nodes.addAll(context.getNodesAdded());
        this.nodes.removeAll(context.getNodesRemoved());
        this.initNodeNamesToServerNames();
        for (TopologyChangeListener listener : this.listeners) {
            listener.topologyChanged(context);
        }
    }

    @Override
    public void registerForTopologyChange(TopologyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Node[] getAllNodes() {
        Assert.assertTrue((this.nodes.size() > 0 ? 1 : 0) != 0);
        return this.nodes.toArray(new Node[this.nodes.size()]);
    }

    private void initNodeNamesToServerNames() {
        String[] serverNames;
        HashMap<String, String> tempNodeNamesToServerNames = new HashMap<String, String>();
        for (String serverName : serverNames = this.configSetupManager.allCurrentlyKnownServers()) {
            try {
                L2Config l2Config = this.configSetupManager.dsoL2ConfigFor(serverName);
                String host = l2Config.tsaGroupPort().getBind();
                if ("0.0.0.0".equals(host)) {
                    host = l2Config.host();
                }
                tempNodeNamesToServerNames.put(host + ":" + l2Config.tsaPort().getValue(), serverName);
            }
            catch (ConfigurationSetupException e) {
                throw new RuntimeException(e);
            }
        }
        this.nodeNamesToServerNames = tempNodeNamesToServerNames;
    }

    @Override
    public String getServerNameFromNodeName(String nodeName) {
        return this.nodeNamesToServerNames.get(nodeName);
    }

    public boolean hasServerInGroup(String serverName) {
        return this.nodeNamesForThisGroup.contains(serverName);
    }

    void updateServerNames(ReloadConfigChangeContext context) {
        HashSet<String> tmp = new HashSet<String>(this.nodeNamesForThisGroup);
        for (Node n : context.getNodesAdded()) {
            tmp.add(n.getServerNodeName());
        }
        for (Node n : context.getNodesRemoved()) {
            tmp.remove(n.getServerNodeName());
        }
        this.nodeNamesForThisGroup = tmp;
    }

    public boolean hasServerInCluster(String name) {
        return this.nodeNamesForThisGroup.contains(name);
    }

    @Override
    public String getGroupNameFromNodeName(String nodeName) {
        if (this.configSetupManager == null) {
            return null;
        }
        ActiveServerGroupConfig asgc = this.configSetupManager.getActiveServerGroupForThisL2();
        if (asgc == null) {
            return null;
        }
        return asgc.getGroupName();
    }
}

