/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L2ConfigurationSetupManagerImpl;
import java.util.HashSet;
import java.util.Set;
import org.terracotta.config.Server;
import org.terracotta.config.Servers;

public class ActiveServerGroupConfigObject
implements ActiveServerGroupConfig {
    private final Servers s;
    private String grpName;
    private final Set<String> members;

    public ActiveServerGroupConfigObject(Servers s, L2ConfigurationSetupManagerImpl setupManager) throws ConfigurationSetupException {
        this.s = s;
        this.members = new HashSet<String>();
        for (Server server : s.getServer()) {
            this.members.add(server.getName());
        }
    }

    @Override
    public int getElectionTimeInSecs() {
        return this.members.size() == 1 ? 0 : 5;
    }

    public void setGroupName(String groupName) {
        this.grpName = groupName;
    }

    @Override
    public String getGroupName() {
        return this.grpName;
    }

    @Override
    public String[] getMembers() {
        return this.members.toArray(new String[this.members.size()]);
    }

    @Override
    public boolean isMember(String l2Name) {
        return this.members.contains(l2Name);
    }

    public static void createDefaultMirrorGroup(Servers servers) {
    }

    public Servers getBean() {
        return this.s;
    }
}

