/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.ActiveServerGroupConfigObject;
import com.tc.config.schema.ActiveServerGroupsConfig;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L2ConfigurationSetupManagerImpl;
import com.tc.util.ActiveCoordinatorHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.terracotta.config.Server;
import org.terracotta.config.Servers;

public class ActiveServerGroupsConfigObject
implements ActiveServerGroupsConfig {
    private final List<ActiveServerGroupConfig> groupConfigs;
    private final Servers servers;

    public ActiveServerGroupsConfigObject(Servers context, L2ConfigurationSetupManagerImpl setupManager) throws ConfigurationSetupException {
        this.servers = context;
        ActiveServerGroupConfigObject[] tempGroupConfigArray = new ActiveServerGroupConfigObject[1];
        for (Server s : this.servers.getServer()) {
            tempGroupConfigArray[0] = new ActiveServerGroupConfigObject(this.servers, setupManager);
        }
        ActiveServerGroupConfigObject[] activeServerGroupConfigObjects = ActiveCoordinatorHelper.generateGroupInfo(tempGroupConfigArray);
        this.groupConfigs = Collections.unmodifiableList(Arrays.asList(activeServerGroupConfigObjects));
    }

    @Override
    public int getActiveServerGroupCount() {
        return this.groupConfigs.size();
    }

    @Override
    public List<ActiveServerGroupConfig> getActiveServerGroups() {
        return this.groupConfigs;
    }

    @Override
    public ActiveServerGroupConfig getActiveServerGroupForL2(String name) {
        for (ActiveServerGroupConfig activeServerGroupConfig : this.groupConfigs) {
            if (!activeServerGroupConfig.isMember(name)) continue;
            return activeServerGroupConfig;
        }
        return null;
    }

    public static void initializeMirrorGroups(Servers servers) {
    }

    public Servers getBean() {
        return this.servers;
    }
}

