/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.CommonL2Config;
import java.io.File;
import org.terracotta.config.BindPort;
import org.terracotta.config.Server;
import org.terracotta.config.TcConfiguration;

public class CommonL2ConfigObject
implements CommonL2Config {
    private final BindPort tsaPort;
    private final BindPort tsaGroupPort;
    private final BindPort managementPort;
    private final String host;
    private final boolean authentication;
    private final String passwordFile;
    private final String loginConfigName;
    private final String accessFile;
    private final boolean httpAuthentication;
    private final String userRealmFile;
    private final boolean secured;
    private final Server server;
    private final TcConfiguration conf;

    public CommonL2ConfigObject(Server server) {
        this(server, null, false);
    }

    public CommonL2ConfigObject(Server context, TcConfiguration conf, boolean secured) {
        this.secured = secured;
        this.server = context;
        this.conf = conf;
        this.host = this.server.getHost();
        this.authentication = false;
        this.passwordFile = null;
        this.accessFile = null;
        this.loginConfigName = null;
        this.httpAuthentication = false;
        if (this.httpAuthentication) {
            // empty if block
        }
        this.userRealmFile = null;
        this.tsaPort = this.server.getTsaPort();
        this.tsaGroupPort = this.server.getTsaGroupPort();
        this.managementPort = this.server.getManagementPort();
    }

    @Override
    public File logsPath() {
        return new File(this.server.getLogs());
    }

    @Override
    public BindPort tsaPort() {
        return this.tsaPort;
    }

    @Override
    public BindPort managementPort() {
        return this.managementPort;
    }

    @Override
    public BindPort tsaGroupPort() {
        return this.tsaGroupPort;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public boolean authentication() {
        return this.authentication;
    }

    @Override
    public String authenticationAccessFile() {
        return this.accessFile;
    }

    @Override
    public String authenticationLoginConfigName() {
        return this.loginConfigName;
    }

    @Override
    public String authenticationPasswordFile() {
        return this.passwordFile;
    }

    @Override
    public boolean httpAuthentication() {
        return this.httpAuthentication;
    }

    @Override
    public String httpAuthenticationUserRealmFile() {
        return this.userRealmFile;
    }

    @Override
    public boolean isSecure() {
        return this.secured;
    }

    public TcConfiguration getBean() {
        return this.conf;
    }
}

