/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.setup.sources.ConfigurationSource;
import com.tc.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;

public class Base64ConfigurationSource
implements ConfigurationSource {
    private final String configString;

    public Base64ConfigurationSource(String base64ConfigString) {
        Assert.assertNotBlank((String)base64ConfigString);
        try {
            this.configString = new String(Base64.getDecoder().decode(base64ConfigString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream(long maxTimeoutMillis) {
        try {
            return new ByteArrayInputStream(this.configString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public File directoryLoadedFrom() {
        return null;
    }

    public boolean isTrusted() {
        return false;
    }

    public String toString() {
        return "string";
    }
}

