/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.setup.ConfigurationCreator;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.util.Assert;
import org.terracotta.config.Servers;
import org.terracotta.config.TcConfiguration;
import org.terracotta.config.TcProperties;

public class BaseConfigurationSetupManager {
    private final String[] args;
    private final ConfigurationCreator configurationCreator;
    private TcConfiguration conf;

    public BaseConfigurationSetupManager(ConfigurationCreator configurationCreator) {
        this(null, configurationCreator);
    }

    public BaseConfigurationSetupManager(String[] args, ConfigurationCreator configurationCreator) {
        Assert.assertNotNull((Object)configurationCreator);
        this.args = args;
        this.configurationCreator = configurationCreator;
    }

    public String[] processArguments() {
        return this.args;
    }

    public final Servers serversBeanRepository() {
        return this.conf.getPlatformConfiguration().getServers();
    }

    protected final TcProperties tcPropertiesRepository() {
        return this.conf.getPlatformConfiguration().getTcProperties();
    }

    protected final ConfigurationCreator configurationCreator() {
        return this.configurationCreator;
    }

    protected final TcConfiguration tcConfigurationRepository() {
        return this.conf;
    }

    protected final void runConfigurationCreator(ClassLoader loader) throws ConfigurationSetupException {
        try {
            this.configurationCreator.createConfiguration(loader);
        }
        catch (Throwable t) {
            throw new ConfigurationSetupException(t);
        }
        this.conf = this.configurationCreator.getParsedConfiguration();
    }
}

