/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.StandardConfigurationSetupManagerFactory;
import com.tc.util.Assert;
import java.io.File;

public class ConfigurationSpec {
    private final String baseConfigSpec;
    private final String serverTopologyOverrideConfigSpec;
    private final StandardConfigurationSetupManagerFactory.ConfigMode configMode;
    private final File workingDir;

    public ConfigurationSpec(String baseConfigSpec, StandardConfigurationSetupManagerFactory.ConfigMode configMode, File workingDir) {
        this(baseConfigSpec, null, configMode, workingDir);
    }

    public ConfigurationSpec(String baseConfigSpec, String serverTopologyOverrideConfigSpec, StandardConfigurationSetupManagerFactory.ConfigMode configMode, File workingDir) {
        Assert.assertNotNull((Object)baseConfigSpec);
        Assert.assertNotBlank((String)baseConfigSpec);
        Assert.assertNotNull((Object)workingDir);
        this.baseConfigSpec = baseConfigSpec;
        this.serverTopologyOverrideConfigSpec = serverTopologyOverrideConfigSpec;
        this.configMode = configMode;
        this.workingDir = workingDir;
    }

    public String getBaseConfigSpec() {
        return this.baseConfigSpec;
    }

    public String getServerTopologyOverrideConfigSpec() throws ConfigurationSetupException {
        if (!this.shouldOverrideServerTopology()) {
            throw new ConfigurationSetupException("Not suppose to override the server topology config : " + (Object)((Object)this.configMode) + "; " + this.serverTopologyOverrideConfigSpec);
        }
        return this.serverTopologyOverrideConfigSpec;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public boolean shouldOverrideServerTopology() {
        return this.configMode != StandardConfigurationSetupManagerFactory.ConfigMode.EXPRESS_L1 && this.serverTopologyOverrideConfigSpec != null;
    }
}

