/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.TcProperty;
import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.ActiveServerGroupConfigObject;
import com.tc.config.schema.CommonL2Config;
import com.tc.config.schema.CommonL2ConfigObject;
import com.tc.config.schema.ConfigTCProperties;
import com.tc.config.schema.ConfigTCPropertiesFromObject;
import com.tc.config.schema.setup.BaseConfigurationSetupManager;
import com.tc.config.schema.setup.ConfigurationCreator;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.config.schema.setup.TopologyReloadStatus;
import com.tc.config.schema.setup.TopologyVerifier;
import com.tc.management.TSAManagementEventPayload;
import com.tc.management.TerracottaRemoteManagement;
import com.tc.object.config.schema.L2Config;
import com.tc.object.config.schema.L2ConfigObject;
import com.tc.operatorevent.TerracottaOperatorEventFactory;
import com.tc.operatorevent.TerracottaOperatorEventLogger;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.server.ServerConnectionValidator;
import com.tc.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.terracotta.config.Server;
import org.terracotta.config.Servers;
import org.terracotta.config.TcConfig;
import org.terracotta.config.TcConfiguration;
import org.terracotta.config.TcProperties;

public class L2ConfigurationSetupManagerImpl
extends BaseConfigurationSetupManager
implements L2ConfigurationSetupManager {
    private final Map<String, L2ConfigData> l2ConfigData = new HashMap<String, L2ConfigData>();
    private final String thisL2Identifier;
    private final L2ConfigData myConfigData;
    private final ConfigTCProperties configTCProperties;
    private final Set<InetAddress> localInetAddresses = this.getAllLocalInetAddresses();
    private final TcConfiguration configuration;
    private volatile ActiveServerGroupConfig activeServerGroupConfig;
    private volatile boolean secure;
    private Servers serversBean;

    public L2ConfigurationSetupManagerImpl(ConfigurationCreator configurationCreator, String thisL2Identifier, ClassLoader loader) throws ConfigurationSetupException {
        this(null, configurationCreator, thisL2Identifier, loader);
    }

    public L2ConfigurationSetupManagerImpl(String[] args, ConfigurationCreator configurationCreator, String thisL2Identifier, ClassLoader loader) throws ConfigurationSetupException {
        super(args, configurationCreator);
        this.runConfigurationCreator(loader);
        this.configTCProperties = new ConfigTCPropertiesFromObject(this.tcPropertiesRepository());
        this.overwriteTcPropertiesFromConfig();
        this.serversBean = this.serversBeanRepository();
        this.secure = this.serversBean != null && this.serversBean.isSecure();
        Server[] servers = this.serversBean != null ? L2ConfigObject.getServers(this.serversBean) : null;
        Server server = null;
        if (thisL2Identifier != null) {
            this.thisL2Identifier = thisL2Identifier;
            if (servers != null) {
                for (Server s : servers) {
                    if (!s.getName().equals(thisL2Identifier)) continue;
                    server = s;
                    break;
                }
            }
        } else {
            server = this.autoChooseThisL2(servers);
            this.thisL2Identifier = server != null ? server.getName() : null;
        }
        this.configuration = this.tcConfigurationRepository();
        this.verifyL2Identifier(servers, this.thisL2Identifier);
        this.myConfigData = this.setupConfigDataForL2(this.thisL2Identifier);
        this.activeServerGroupConfig = new ActiveServerGroupConfigObject(this.configuration.getPlatformConfiguration().getServers(), this);
    }

    @Override
    public TopologyReloadStatus reloadConfiguration(ServerConnectionValidator serverConnectionValidator, TerracottaOperatorEventLogger opEventLogger) throws ConfigurationSetupException {
        String reloadSource = this.configurationCreator().reloadServersConfiguration(false, false);
        Servers changedL2sBeanRepository = this.configurationCreator().getParsedConfiguration().getPlatformConfiguration().getServers();
        opEventLogger.fireOperatorEvent(TerracottaOperatorEventFactory.createConfigReloadedEvent((String)reloadSource));
        TopologyVerifier topologyVerifier = new TopologyVerifier(this.serversBeanRepository(), changedL2sBeanRepository, this.activeServerGroupConfig, serverConnectionValidator);
        TopologyReloadStatus status = topologyVerifier.checkAndValidateConfig();
        if (TopologyReloadStatus.TOPOLOGY_CHANGE_ACCEPTABLE != status) {
            return status;
        }
        this.configurationCreator().reloadServersConfiguration(true, true);
        this.l2ConfigData.clear();
        this.serversBean = this.configurationCreator().getParsedConfiguration().getPlatformConfiguration().getServers();
        this.activeServerGroupConfig = new ActiveServerGroupConfigObject(this.serversBean, this);
        TSAManagementEventPayload tsaManagementEventPayload = new TSAManagementEventPayload("TSA.TOPOLOGY.CONFIG_RELOADED");
        TerracottaRemoteManagement.getRemoteManagementInstance().sendEvent(tsaManagementEventPayload.toManagementEvent());
        return TopologyReloadStatus.TOPOLOGY_CHANGE_ACCEPTABLE;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public String getL2Identifier() {
        return this.thisL2Identifier;
    }

    private void verifyL2Identifier(Server[] servers, String l2Identifier) throws ConfigurationSetupException {
        if (servers == null) {
            return;
        }
        boolean found = false;
        for (Server server : servers) {
            if (!server.getName().equals(l2Identifier)) continue;
            found = true;
            break;
        }
        if (servers.length > 0 && !found) {
            throw new ConfigurationSetupException("You have specified server name '" + l2Identifier + "' which does not exist in the specified tc-config file. \n\nPlease check your settings and try again.");
        }
    }

    private Server autoChooseThisL2(Server[] servers) throws ConfigurationSetupException {
        Server myL2 = null;
        if (servers != null) {
            if (servers.length == 1) {
                myL2 = servers[0];
            } else {
                try {
                    for (Server server : servers) {
                        if (!this.localInetAddresses.contains(InetAddress.getByName(server.getHost()))) continue;
                        if (myL2 == null) {
                            myL2 = server;
                            continue;
                        }
                        throw new ConfigurationSetupException("You have not specified a name for your Terracotta server, and there are " + servers.length + " servers defined in the Terracotta configuration file. The script can not automatically choose between the following server names: " + myL2.getName() + ", " + server.getName() + ". Pass the desired server name to the script using the -n flag.");
                    }
                }
                catch (UnknownHostException uhe) {
                    throw new ConfigurationSetupException("Exception when trying to choose this L2 instance : " + uhe);
                }
            }
        }
        return myL2;
    }

    private Set<InetAddress> getAllLocalInetAddresses() {
        Enumeration<NetworkInterface> networkInterfaces;
        HashSet<InetAddress> localAddresses = new HashSet<InetAddress>();
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        while (networkInterfaces.hasMoreElements()) {
            Enumeration<InetAddress> inetAddresses = networkInterfaces.nextElement().getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                localAddresses.add(inetAddresses.nextElement());
            }
        }
        return localAddresses;
    }

    @Override
    public String describeSources() {
        return this.configurationCreator().describeSources();
    }

    private synchronized L2ConfigData configDataFor(String name) throws ConfigurationSetupException {
        L2ConfigData out = this.l2ConfigData.get(name);
        if (out == null) {
            out = new L2ConfigData(name, this.serversBean);
            if (!out.explicitlySpecifiedInConfigFile() && name != null) {
                String list;
                Servers servers = this.serversBeanRepository();
                if (servers == null) {
                    list = "[data unavailable]";
                } else {
                    Server[] serverList = L2ConfigObject.getServers(servers);
                    if (serverList == null) {
                        list = "[data unavailable]";
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < serverList.length; ++i) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            if (i == serverList.length - 1) {
                                sb.append("and ");
                            }
                            sb.append("'").append(serverList[i].getName()).append("'");
                        }
                        list = sb.toString();
                    }
                }
                throw new ConfigurationSetupException("Multiple <server> elements are defined in the configuration file. As such, each server that you start needs to know which configuration it should use.\n\nHowever, this server couldn't figure out which one it is -- it thinks it's called '" + name + "', but you've only created <server> elements in the config file called " + list + ".\n\nPlease re-start the server with a '-n <name>' argument on the command line to tell this server which one it is, or change the 'name' attributes of the <server> elements in the config file as appropriate.");
            }
            this.l2ConfigData.put(name, out);
        }
        return out;
    }

    private L2ConfigData setupConfigDataForL2(String l2Identifier) throws ConfigurationSetupException {
        L2ConfigData serverConfigData = this.configDataFor(l2Identifier);
        return serverConfigData;
    }

    @Override
    public CommonL2Config commonL2ConfigFor(String name) throws ConfigurationSetupException {
        return this.configDataFor(name).commonL2Config();
    }

    @Override
    public CommonL2Config commonl2Config() {
        return this.myConfigData.commonL2Config();
    }

    @Override
    public L2Config dsoL2ConfigFor(String name) throws ConfigurationSetupException {
        return this.configDataFor(name).dsoL2Config();
    }

    @Override
    public L2Config dsoL2Config() {
        return this.myConfigData.dsoL2Config();
    }

    @Override
    public String[] allCurrentlyKnownServers() {
        ArrayList<String> servers = new ArrayList<String>();
        for (String member : this.activeServerGroupConfig.getMembers()) {
            servers.add(member);
        }
        return servers.toArray(new String[servers.size()]);
    }

    @Override
    public InputStream rawConfigFile() {
        String text = this.configurationCreator().rawConfigText();
        try {
            return new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw Assert.failure((Object)"This shouldn't be possible", (Throwable)uee);
        }
    }

    @Override
    public InputStream effectiveConfigFile() {
        TcConfig config = new TcConfig();
        TcProperties tcProperties = this.tcPropertiesRepository();
        Servers servers = this.serversBeanRepository();
        if (servers != null) {
            config.setServers(servers);
        }
        if (tcProperties != null) {
            config.setTcProperties(tcProperties);
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TcConfig.class});
            StringWriter sw = new StringWriter();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)config, (Writer)sw);
            return new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | JAXBException e) {
            throw Assert.failure((Object)"This shouldn't be possible", (Throwable)e);
        }
    }

    private void overwriteTcPropertiesFromConfig() {
        TCProperties tcProps = TCPropertiesImpl.getProperties();
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (TcProperty tcp : this.configTCProperties.getTcPropertiesArray()) {
            propMap.put(tcp.getPropertyName().trim(), tcp.getPropertyValue().trim());
        }
        tcProps.overwriteTcPropertiesFromConfig(propMap);
    }

    @Override
    public ActiveServerGroupConfig getActiveServerGroupForThisL2() {
        return this.activeServerGroupConfig;
    }

    private class L2ConfigData {
        private final String name;
        private final CommonL2Config commonL2Config;
        private final L2Config dsoL2Config;

        public L2ConfigData(String name, Servers serversBean) throws ConfigurationSetupException {
            this.name = name;
            Server s = this.findMyL2Bean();
            this.commonL2Config = new CommonL2ConfigObject(s, L2ConfigurationSetupManagerImpl.this.configuration, L2ConfigurationSetupManagerImpl.this.secure);
            this.dsoL2Config = new L2ConfigObject(s, serversBean.getClientReconnectWindow());
        }

        public CommonL2Config commonL2Config() {
            return this.commonL2Config;
        }

        public L2Config dsoL2Config() {
            return this.dsoL2Config;
        }

        public boolean explicitlySpecifiedInConfigFile() throws ConfigurationSetupException {
            return this.findMyL2Bean() != null;
        }

        private Server findMyL2Bean() throws ConfigurationSetupException {
            Server[] l2Array;
            Servers servers = L2ConfigurationSetupManagerImpl.this.serversBeanRepository();
            Server[] serverArray = l2Array = servers == null ? null : L2ConfigObject.getServers(servers);
            if (l2Array == null || l2Array.length == 0) {
                return null;
            }
            if (this.name == null) {
                if (l2Array.length > 1) {
                    Server rv = L2ConfigurationSetupManagerImpl.this.autoChooseThisL2(l2Array);
                    if (rv == null) {
                        throw new ConfigurationSetupException("You have not specified a name for your Terracotta server, and there are " + l2Array.length + " servers defined in the Terracotta configuration file.  Pass the desired server name to the script using the -n flag.");
                    }
                    return rv;
                }
                return l2Array[0];
            }
            for (Server aL2Array : l2Array) {
                if (!this.name.trim().equals(aL2Array.getName().trim())) continue;
                return aL2Array;
            }
            return null;
        }
    }
}

