/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.setup.BaseConfigurationSetupManagerFactory;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.ConfigurationSpec;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.config.schema.setup.L2ConfigurationSetupManagerImpl;
import com.tc.config.schema.setup.StandardXMLFileConfigurationCreator;
import com.tc.security.PwProvider;
import com.tc.text.StringUtils;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class StandardConfigurationSetupManagerFactory
extends BaseConfigurationSetupManagerFactory {
    private static final String CONFIG_SPEC_ARGUMENT_NAME = "config";
    public static final String CONFIG_SPEC_ARGUMENT_WORD = "--config";
    public static final String SERVER_NAME_ARGUMENT_WORD = "-n";
    private static final String L2_NAME_PROPERTY_NAME = "tc.server.name";
    public static final String DEFAULT_CONFIG_SPEC = "tc-config.xml";
    public static final String DEFAULT_CONFIG_PATH = "default-config.xml";
    public static final String DEFAULT_CONFIG_URI = "resource:///" + StandardConfigurationSetupManagerFactory.class.getPackage().getName().replace('.', '/') + "/" + "default-config.xml";
    private final String[] args;
    private final String defaultL2Identifier;
    private final ConfigurationSpec configurationSpec;
    private final PwProvider pwProvider;

    public StandardConfigurationSetupManagerFactory(String[] args, ConfigMode configMode, PwProvider pwProvider) throws ConfigurationSetupException {
        this(args, StandardConfigurationSetupManagerFactory.parseDefaultCommandLine(args, configMode), configMode, pwProvider);
    }

    public StandardConfigurationSetupManagerFactory(String[] args, CommandLine commandLine, ConfigMode configMode, PwProvider pwProvider) throws ConfigurationSetupException {
        this(args, commandLine, configMode, System.getProperty("tc.config"), pwProvider);
    }

    public StandardConfigurationSetupManagerFactory(String[] args, ConfigMode configMode, String configSpec, PwProvider pwProvider) throws ConfigurationSetupException {
        this(args, StandardConfigurationSetupManagerFactory.parseDefaultCommandLine(args, configMode), configMode, configSpec, pwProvider);
    }

    private static CommandLine parseDefaultCommandLine(String[] args, ConfigMode configMode) throws ConfigurationSetupException {
        try {
            if (args == null || args.length == 0) {
                return new PosixParser().parse(new Options(), new String[0]);
            }
            Options options = StandardConfigurationSetupManagerFactory.createOptions(configMode);
            return new PosixParser().parse(options, args);
        }
        catch (ParseException pe) {
            throw new ConfigurationSetupException(pe.getLocalizedMessage(), (Throwable)pe);
        }
    }

    public StandardConfigurationSetupManagerFactory(String[] args, CommandLine commandLine, ConfigMode configMode, String configSpec, PwProvider pwProvider) throws ConfigurationSetupException {
        String effectiveConfigSpec = this.getEffectiveConfigSpec(configSpec, commandLine, configMode);
        String cwdAsString = System.getProperty("user.dir");
        if (StringUtils.isBlank((String)cwdAsString)) {
            throw new ConfigurationSetupException("We can't find the working directory of the process; we need this to continue. (The system property 'user.dir' was " + (cwdAsString == null ? "null" : "'" + cwdAsString + "'") + ".)");
        }
        this.args = args;
        this.configurationSpec = new ConfigurationSpec(effectiveConfigSpec, System.getProperty("tc.server.topology"), configMode, new File(cwdAsString));
        this.defaultL2Identifier = this.getDefaultL2Identifier(commandLine);
        this.pwProvider = pwProvider;
    }

    private String getDefaultL2Identifier(CommandLine commandLine) {
        String l2NameOnCommandLine = StringUtils.trimToNull((String)commandLine.getOptionValue('n'));
        String specifiedL2Identifier = StringUtils.trimToNull((String)(l2NameOnCommandLine != null ? l2NameOnCommandLine : System.getProperty(L2_NAME_PROPERTY_NAME)));
        return specifiedL2Identifier;
    }

    private String getEffectiveConfigSpec(String configSpec, CommandLine commandLine, ConfigMode configMode) throws ConfigurationSetupException {
        String configFileOnCommandLine = null;
        configFileOnCommandLine = StringUtils.trimToNull((String)commandLine.getOptionValue('f'));
        String effectiveConfigSpec = StringUtils.trimToNull((String)(configFileOnCommandLine != null ? configFileOnCommandLine : configSpec));
        if (StringUtils.isBlank((String)effectiveConfigSpec)) {
            File localConfig = new File(System.getProperty("user.dir"), DEFAULT_CONFIG_SPEC);
            if (localConfig.exists()) {
                effectiveConfigSpec = localConfig.getAbsolutePath();
            } else if (configMode == ConfigMode.L2) {
                effectiveConfigSpec = DEFAULT_CONFIG_URI;
            }
        }
        if (StringUtils.isBlank((String)effectiveConfigSpec)) {
            throw new ConfigurationSetupException("You must specify the location of the Terracotta configuration file for this process, using the 'tc.config' system property.");
        }
        return effectiveConfigSpec;
    }

    public static Options createOptions(ConfigMode configMode) {
        Options options = new Options();
        Option configFileOption = new Option("f", CONFIG_SPEC_ARGUMENT_NAME, true, "the configuration file to use, specified as a file path or URL");
        configFileOption.setArgName("file-or-URL");
        configFileOption.setType(String.class);
        if (configMode == ConfigMode.L2) {
            configFileOption.setRequired(false);
            options.addOption(configFileOption);
            Option l2NameOption = new Option("n", "name", true, "the name of this L2; defaults to the host name");
            l2NameOption.setRequired(false);
            l2NameOption.setArgName("l2-name");
            options.addOption(l2NameOption);
        } else {
            configFileOption.setRequired(true);
            options.addOption(configFileOption);
        }
        return options;
    }

    @Override
    public L2ConfigurationSetupManager createL2TVSConfigurationSetupManager(String l2Name, ClassLoader loader) throws ConfigurationSetupException {
        if (l2Name == null) {
            l2Name = this.defaultL2Identifier;
        }
        StandardXMLFileConfigurationCreator configurationCreator = new StandardXMLFileConfigurationCreator(this.configurationSpec, this.beanFactory, this.pwProvider);
        return new L2ConfigurationSetupManagerImpl(this.args, configurationCreator, l2Name, loader);
    }

    public String[] getArguments() {
        return this.args;
    }

    public static enum ConfigMode {
        L2,
        CUSTOM_L1,
        EXPRESS_L1;

    }
}

