/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.setup.TopologyReloadStatus;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.server.ServerConnectionValidator;
import java.util.Set;
import org.terracotta.config.Servers;

public class TopologyVerifier {
    private final Servers oldServersBean;
    private final Servers newServersBean;
    private final ActiveServerGroupConfig oldGroupsInfo;
    private final ServerConnectionValidator serverConnectionValidator;
    private static final TCLogger logger = TCLogging.getLogger(TopologyVerifier.class);

    TopologyVerifier(Servers oldServers, Servers newServers, ActiveServerGroupConfig oldGroupsInfo, ServerConnectionValidator serverConnectionValidator) {
        this.oldServersBean = oldServers;
        this.newServersBean = newServers;
        this.oldGroupsInfo = oldGroupsInfo;
        this.serverConnectionValidator = serverConnectionValidator;
    }

    public TopologyReloadStatus checkAndValidateConfig() {
        TopologyReloadStatus topologyStatus = this.checkExistingServerConfigIsSame();
        if (topologyStatus != TopologyReloadStatus.TOPOLOGY_CHANGE_ACCEPTABLE) {
            return topologyStatus;
        }
        topologyStatus = this.checkGroupInfo();
        if (topologyStatus != TopologyReloadStatus.TOPOLOGY_CHANGE_ACCEPTABLE) {
            return topologyStatus;
        }
        return this.checkIfServersAlive();
    }

    private TopologyReloadStatus checkIfServersAlive() {
        Set<String> membersRemoved = this.getRemovedMembers();
        for (String member : membersRemoved) {
            if (!this.serverConnectionValidator.isAlive(member)) continue;
            logger.warn((Object)("Reloading servers config failed as " + member + " is still alive."));
            return TopologyReloadStatus.SERVER_STILL_ALIVE;
        }
        return TopologyReloadStatus.TOPOLOGY_CHANGE_ACCEPTABLE;
    }

    private TopologyReloadStatus checkGroupInfo() {
        if (this.isGroupsSizeEqualsOne()) {
            return TopologyReloadStatus.TOPOLOGY_CHANGE_ACCEPTABLE;
        }
        if (!this.isGroupNameSpecified()) {
            return TopologyReloadStatus.SPECIFY_MIRROR_GROUPS;
        }
        if (!this.isGroupNameSame()) {
            return TopologyReloadStatus.TOPOLOGY_CHANGE_UNACCEPTABLE;
        }
        if (this.isMemberMovedToDifferentGroup()) {
            return TopologyReloadStatus.TOPOLOGY_CHANGE_UNACCEPTABLE;
        }
        return TopologyReloadStatus.TOPOLOGY_CHANGE_ACCEPTABLE;
    }

    private boolean isGroupsSizeEqualsOne() {
        return true;
    }

    private boolean isGroupNameSpecified() {
        return false;
    }

    private boolean isMemberMovedToDifferentGroup() {
        return false;
    }

    private boolean isGroupNameSame() {
        return false;
    }

    private TopologyReloadStatus checkExistingServerConfigIsSame() {
        return TopologyReloadStatus.TOPOLOGY_CHANGE_ACCEPTABLE;
    }

    private Set<String> getRemovedMembers() {
        return null;
    }
}

