/*
 * Decompiled with CFR 0.152.
 */
package com.tc.handler;

import com.tc.handler.CallbackDirtyDatabaseCleanUpAdapter;
import com.tc.handler.CallbackHandlerResources;
import com.tc.logging.CallbackOnExitState;
import com.tc.logging.TCLogger;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;

public class CallbackZapDirtyDbExceptionAdapter
extends CallbackDirtyDatabaseCleanUpAdapter {
    private static final TCProperties l2Props = TCPropertiesImpl.getProperties();
    private final TCLogger consoleLogger;

    public CallbackZapDirtyDbExceptionAdapter(TCLogger logger, TCLogger consoleLogger, ClusterStatePersistor clusterStateStore) {
        super(logger, clusterStateStore);
        this.consoleLogger = consoleLogger;
    }

    @Override
    public void callbackOnExit(CallbackOnExitState state) {
        super.callbackOnExit(state);
        boolean autoDelete = l2Props.getBoolean("l2.nha.dirtydb.autoDelete", true);
        boolean autoRestart = l2Props.getBoolean("l2.nha.autoRestart", true);
        if (autoDelete && autoRestart) {
            this.consoleLogger.error((Object)(CallbackHandlerResources.getDirtyDBAutodeleteAutoRestartZapMessage() + "\n"));
        } else if (autoDelete && !autoRestart) {
            this.consoleLogger.error((Object)(CallbackHandlerResources.getDirtyDBAutodeleteZapMessage() + "\n"));
        } else if (!autoDelete && autoRestart) {
            this.consoleLogger.error((Object)(CallbackHandlerResources.getDirtyDBAutoRestartZapMessage() + "\n"));
        } else {
            this.consoleLogger.error((Object)(CallbackHandlerResources.getDirtyDBZapMessage() + "\n"));
        }
    }
}

