/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.objectserver.impl.ThisServerNodeId;
import com.tc.properties.TCPropertiesImpl;

public abstract class L2DebugLogging {
    private static final String L2_DEBUG_LOGGING_PROP_NAME = "l2.debug-logging";
    private static final boolean ENABLED = TCPropertiesImpl.getProperties().getBoolean("l2.debug-logging", false);

    public static boolean isDebugLogging() {
        return ENABLED;
    }

    public static void log(TCLogger log, LogLevel level, String message, Throwable throwable) {
        if (!ENABLED) {
            return;
        }
        message = "[" + ThisServerNodeId.getThisServerNodeId() + "] " + message;
        switch (level) {
            case ERROR: {
                if (throwable != null) {
                    log.error((Object)message, throwable);
                    break;
                }
                log.error((Object)message);
                break;
            }
            case WARN: {
                if (throwable != null) {
                    log.warn((Object)message, throwable);
                    break;
                }
                log.warn((Object)message);
                break;
            }
            case INFO: {
                if (throwable != null) {
                    log.info((Object)message, throwable);
                    break;
                }
                log.info((Object)message);
                break;
            }
            case DEBUG: {
                if (throwable != null) {
                    log.debug((Object)message, throwable);
                    break;
                }
                log.debug((Object)message);
                break;
            }
            default: {
                if (throwable != null) {
                    log.error((Object)message, throwable);
                    break;
                }
                log.error((Object)message);
            }
        }
    }

    static {
        TCLogger logger = TCLogging.getLogger(L2DebugLogging.class);
        logger.info((Object)("L2 debug logging: " + (ENABLED ? "ENABLED" : "DISABLED")));
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }
}

