/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.l2.ha.ClusterIDMissmatchException;
import com.tc.l2.ha.ClusterState;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.StripeID;
import com.tc.net.groups.StripeIDStateManager;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.objectserver.api.ClientNotFoundException;
import com.tc.objectserver.persistence.ClientStatePersistor;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.util.State;
import com.tc.util.UUID;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClusterStateImpl
implements ClusterState {
    private static final TCLogger logger = TCLogging.getLogger(ClusterState.class);
    private final ClusterStatePersistor clusterStatePersistor;
    private final ClientStatePersistor clientStatePersistor;
    private final ConnectionIDFactory connectionIdFactory;
    private final StripeIDStateManager stripeIDStateManager;
    private final Set<ConnectionID> connections = Collections.synchronizedSet(new HashSet());
    private long nextAvailChannelID = -1L;
    private State currentState;
    private StripeID stripeID;

    public ClusterStateImpl(ClusterStatePersistor clusterStatePersistor, ClientStatePersistor clientStatePersistor, ConnectionIDFactory connectionIdFactory, StripeIDStateManager stripeIDStateManager) {
        this.clusterStatePersistor = clusterStatePersistor;
        this.clientStatePersistor = clientStatePersistor;
        this.connectionIdFactory = connectionIdFactory;
        this.stripeIDStateManager = stripeIDStateManager;
        this.stripeID = clusterStatePersistor.getThisStripeID();
        this.nextAvailChannelID = this.connectionIdFactory.getCurrentConnectionID();
    }

    public long getNextAvailableChannelID() {
        return this.nextAvailChannelID;
    }

    public void setNextAvailableChannelID(long nextAvailableCID) {
        if (nextAvailableCID < this.nextAvailChannelID) {
            logger.error((Object)("Trying to set Next Available ChannelID to a lesser value : known = " + this.nextAvailChannelID + " new value = " + nextAvailableCID + " IGNORING"));
            return;
        }
        this.nextAvailChannelID = nextAvailableCID;
        this.clientStatePersistor.getConnectionIDSequence().setNext(this.nextAvailChannelID);
    }

    public void syncActiveState() {
        this.connectionIdFactory.activate(this.stripeID, this.nextAvailChannelID);
    }

    public void syncSequenceState() {
    }

    public StripeID getStripeID() {
        return this.stripeID;
    }

    public boolean isStripeIDNull() {
        return this.stripeID.isNull();
    }

    public void setStripeID(String uid) {
        if (!this.isStripeIDNull() && !this.stripeID.getName().equals(uid)) {
            logger.error((Object)("StripeID doesnt match !! Mine : " + this.stripeID + " Active sent clusterID as : " + uid));
            throw new ClusterIDMissmatchException(this.stripeID.getName(), uid);
        }
        this.stripeID = new StripeID(uid);
        this.syncStripeIDToDB();
        this.stripeIDStateManager.verifyOrSaveStripeID(this.stripeID, true);
    }

    private void syncStripeIDToDB() {
        this.clusterStatePersistor.setThisStripeID(this.stripeID);
    }

    public void setCurrentState(State state) {
        this.currentState = state;
        this.syncCurrentStateToDB();
    }

    private void syncCurrentStateToDB() {
        this.clusterStatePersistor.setCurrentL2State(this.currentState);
    }

    public void addNewConnection(ConnectionID connID) {
        if (connID.getChannelID() >= this.nextAvailChannelID) {
            this.nextAvailChannelID = connID.getChannelID() + 1L;
            this.clientStatePersistor.getConnectionIDSequence().setNext(this.nextAvailChannelID);
        }
        this.connections.add(connID);
        this.clientStatePersistor.saveClientState(connID.getClientID());
    }

    public void removeConnection(ConnectionID connectionID) {
        boolean removed = this.connections.remove(connectionID);
        if (!removed) {
            logger.warn((Object)("Connection ID not found : " + connectionID + " Current Connections count : " + this.connections.size()));
        } else {
            try {
                this.clientStatePersistor.deleteClientState(connectionID.getClientID());
            }
            catch (ClientNotFoundException notfound) {
                logger.warn((Object)"not found", (Throwable)notfound);
            }
        }
    }

    public Set<ConnectionID> getAllConnections() {
        return new HashSet<ConnectionID>(this.connections);
    }

    public void generateStripeIDIfNeeded() {
        if (this.isStripeIDNull()) {
            this.setStripeID(UUID.getUUID().toString());
        }
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("ClusterState [ ");
        strBuilder.append("Connections [ ").append(this.connections).append(" ]");
        strBuilder.append(" nextAvailChannelID: ").append(this.nextAvailChannelID);
        strBuilder.append(" currentState: ").append(this.currentState);
        strBuilder.append(" stripeID: ").append(this.stripeID);
        strBuilder.append(" ]");
        return strBuilder.toString();
    }
}

