/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.properties.TCProperties;
import java.util.concurrent.TimeUnit;

public class HASettingsChecker {
    private final L2ConfigurationSetupManager tcConfig;
    private final TCProperties tcProperties;
    private static final TCLogger logger = CustomerLogging.getDSOGenericLogger();
    private final boolean isHighAvailabilityEnabled;
    private final int l1l2PingIdleTime;
    private final int l1l2SocketConnectCount;
    private final int l1l2PingInterval;
    private final int l1l2PingProbes;
    private final int l1l2SocketConnectTimeout;
    private final int l2l2PingIdleTime;
    private final int l2l2SocketConnectCount;
    private final int l2l2PingInterval;
    private final int l2l2PingProbes;
    private final int l2l2SocketConnectTimeout;
    private final long clientReconnectWindow;
    private final long electionTime;
    private final int l1l2HealthCheckFailureTolerance;
    private final int l2l2HealthCheckFailureTolerance;

    public HASettingsChecker(L2ConfigurationSetupManager config, TCProperties props) {
        this.tcConfig = config;
        this.tcProperties = props;
        this.l1l2PingIdleTime = this.tcProperties.getInt("l1.healthcheck.l2.ping.idletime");
        this.l1l2SocketConnectCount = this.tcProperties.getInt("l1.healthcheck.l2.socketConnectCount");
        this.l1l2PingInterval = this.tcProperties.getInt("l1.healthcheck.l2.ping.interval");
        this.l1l2PingProbes = this.tcProperties.getInt("l1.healthcheck.l2.ping.probes");
        this.l1l2SocketConnectTimeout = this.tcProperties.getInt("l1.healthcheck.l2.socketConnectTimeout");
        this.l2l2PingIdleTime = this.tcProperties.getInt("l2.healthcheck.l2.ping.idletime");
        this.l2l2SocketConnectCount = this.tcProperties.getInt("l2.healthcheck.l2.socketConnectCount");
        this.l2l2PingInterval = this.tcProperties.getInt("l2.healthcheck.l2.ping.interval");
        this.l2l2PingProbes = this.tcProperties.getInt("l2.healthcheck.l2.ping.probes");
        this.l2l2SocketConnectTimeout = this.tcProperties.getInt("l2.healthcheck.l2.socketConnectTimeout");
        this.l1l2HealthCheckFailureTolerance = this.interNodeHealthCheckTime(this.l1l2PingIdleTime, this.l1l2SocketConnectCount, this.l1l2PingInterval, this.l1l2PingProbes, this.l1l2SocketConnectTimeout);
        this.l2l2HealthCheckFailureTolerance = this.interNodeHealthCheckTime(this.l2l2PingIdleTime, this.l2l2SocketConnectCount, this.l2l2PingInterval, this.l2l2PingProbes, this.l2l2SocketConnectTimeout);
        this.clientReconnectWindow = TimeUnit.SECONDS.toMillis(config.dsoL2Config().clientReconnectWindow());
        this.electionTime = TimeUnit.SECONDS.toMillis(config.getActiveServerGroupForThisL2().getElectionTimeInSecs());
        this.isHighAvailabilityEnabled = this.checkIfHighAvailabilityIsEnabled(this.tcConfig, this.tcProperties);
    }

    public void validateHealthCheckSettingsForHighAvailability() {
        if (this.isHighAvailabilityEnabled) {
            this.printWarningIfL1L2FailureToleranceHigherThanL2L2FailureTolerance();
            this.printWarningIfL1DisconnectIsLowerThanL2DisconnectPlusElectionTime();
        }
    }

    public void printWarningIfL1L2FailureToleranceHigherThanL2L2FailureTolerance() {
        if (this.isL1L2FailureToleranceHigherThanL2L2FailureTolerance()) {
            logger.warn((Object)"High Availability Not Configured Properly: L1L2HealthCheck should be less than L2-L2HealthCheck + ElectionTime + ClientReconnectWindow");
        }
    }

    public void printWarningIfL1DisconnectIsLowerThanL2DisconnectPlusElectionTime() {
        if (this.isL1DisconnectIsLowerThanL2DisconnectPlusElectionTime()) {
            logger.warn((Object)"High Availability Not Configured Properly: L1L2HealthCheck should be more than L2-L2HealthCheck + ElectionTime");
        }
    }

    private boolean isL1L2FailureToleranceHigherThanL2L2FailureTolerance() {
        long l1MaxFailoverWindow = (long)this.l2l2HealthCheckFailureTolerance + this.electionTime + this.clientReconnectWindow;
        return (long)this.l1l2HealthCheckFailureTolerance > l1MaxFailoverWindow;
    }

    private boolean isL1DisconnectIsLowerThanL2DisconnectPlusElectionTime() {
        long l1MinFailoverWindow = (long)this.l2l2HealthCheckFailureTolerance + this.electionTime;
        return (long)this.l1l2HealthCheckFailureTolerance < l1MinFailoverWindow;
    }

    private int interNodeHealthCheckTime(int pingIdleTime, int socketConnectCount, int pingInterval, int pingProbes, int socketConnectTimeout) {
        return pingIdleTime + socketConnectCount * (pingInterval * pingProbes + socketConnectTimeout * pingInterval);
    }

    private boolean checkIfHighAvailabilityIsEnabled(L2ConfigurationSetupManager config, TCProperties tcprops) {
        return tcprops.getBoolean("l1.healthcheck.l2.ping.enabled") && tcprops.getBoolean("l2.healthcheck.l2.ping.enabled") && tcprops.getBoolean("l2.l1reconnect.enabled");
    }
}

