/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.async.api.StageManager;
import com.tc.config.schema.setup.L2ConfigurationSetupManager;
import com.tc.l2.api.L2Coordinator;
import com.tc.l2.api.ReplicatedClusterStateManager;
import com.tc.l2.ha.ClusterStateImpl;
import com.tc.l2.ha.L2HAZapNodeRequestProcessor;
import com.tc.l2.ha.ReplicatedClusterStateManagerImpl;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.operatorevent.OperatorEventsZapRequestListener;
import com.tc.l2.state.StateManager;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.NodeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.StripeIDStateManager;
import com.tc.objectserver.handler.ChannelLifeCycleHandler;
import com.tc.objectserver.impl.DistributedObjectServer;
import com.tc.objectserver.persistence.Persistor;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;

public class L2HACoordinator
implements L2Coordinator {
    private static final TCLogger logger = TCLogging.getLogger(L2HACoordinator.class);
    private final TCLogger consoleLogger;
    private final DistributedObjectServer server;
    private final GroupManager<AbstractGroupMessage> groupManager;
    private StateManager stateManager;
    private ReplicatedClusterStateManager rClusterStateMgr;
    private final L2ConfigurationSetupManager configSetupManager;

    public L2HACoordinator(TCLogger consoleLogger, DistributedObjectServer server, StageManager stageManager, StateManager stateManager, GroupManager<AbstractGroupMessage> groupCommsManager, Persistor persistor, WeightGeneratorFactory weightGeneratorFactory, L2ConfigurationSetupManager configurationSetupManager, StripeIDStateManager stripeIDStateManager, ChannelLifeCycleHandler clm) {
        this.consoleLogger = consoleLogger;
        this.server = server;
        this.groupManager = groupCommsManager;
        this.stateManager = stateManager;
        this.configSetupManager = configurationSetupManager;
        this.init(stageManager, persistor, weightGeneratorFactory, stripeIDStateManager, clm);
    }

    private void init(StageManager stageManager, Persistor persistor, WeightGeneratorFactory weightGeneratorFactory, StripeIDStateManager stripeIDStateManager, ChannelLifeCycleHandler clm) {
        ClusterStateImpl clusterState = new ClusterStateImpl(persistor.getClusterStatePersistor(), persistor.getClientStatePersistor(), this.server.getConnectionIdFactory(), stripeIDStateManager);
        L2HAZapNodeRequestProcessor zapProcessor = new L2HAZapNodeRequestProcessor(this.consoleLogger, this.stateManager, this.groupManager, weightGeneratorFactory, persistor.getClusterStatePersistor());
        zapProcessor.addZapEventListener(new OperatorEventsZapRequestListener(this.configSetupManager));
        this.groupManager.setZapNodeRequestProcessor(zapProcessor);
        this.rClusterStateMgr = new ReplicatedClusterStateManagerImpl(this.groupManager, this.stateManager, clusterState, this.server.getConnectionIdFactory(), clm);
    }

    @Override
    public void start() {
        this.stateManager.startElection();
    }

    @Override
    public StateManager getStateManager() {
        return this.stateManager;
    }

    @Override
    public ReplicatedClusterStateManager getReplicatedClusterStateManager() {
        return this.rClusterStateMgr;
    }

    @Override
    public GroupManager<AbstractGroupMessage> getGroupManager() {
        return this.groupManager;
    }

    @Override
    public void nodeJoined(NodeID nodeID) {
        this.log(nodeID + " joined the cluster");
        if (this.stateManager.isActiveCoordinator()) {
            try {
                this.stateManager.publishActiveState(nodeID);
                this.rClusterStateMgr.publishClusterState(nodeID);
            }
            catch (GroupException ge) {
                String errMesg = "A Terracotta server tried to join the mirror group as a second ACTIVE: " + nodeID + " Zapping it to allow it to join as PASSIVE standby (backup): ";
                logger.error((Object)errMesg, (Throwable)ge);
                this.groupManager.zapNode(nodeID, 1, errMesg + L2HAZapNodeRequestProcessor.getErrorString(ge));
            }
        }
    }

    private void log(String message) {
        logger.info((Object)message);
        this.consoleLogger.info((Object)message);
    }

    private void warn(String message) {
        logger.warn((Object)message);
        this.consoleLogger.warn((Object)message);
    }

    @Override
    public void nodeLeft(NodeID nodeID) {
        this.warn(nodeID + " left the cluster");
        if (this.stateManager.isActiveCoordinator()) {
            Assert.assertFalse((nodeID.getNodeType() == 1 ? 1 : 0) != 0);
        } else {
            this.stateManager.startElectionIfNecessary(nodeID);
        }
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        out.indent().visit((Object)this.rClusterStateMgr).flush();
        return out;
    }
}

