/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.exception.TCRuntimeException;
import com.tc.l2.api.ReplicatedClusterStateManager;
import com.tc.l2.ha.ClusterState;
import com.tc.l2.ha.L2HAZapNodeRequestProcessor;
import com.tc.l2.msg.ClusterStateMessage;
import com.tc.l2.state.StateManager;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.GroupMessageListener;
import com.tc.net.groups.GroupResponse;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionIDFactoryListener;
import com.tc.objectserver.handler.ChannelLifeCycleHandler;
import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import com.tc.util.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ReplicatedClusterStateManagerImpl
implements ReplicatedClusterStateManager,
GroupMessageListener<ClusterStateMessage>,
ConnectionIDFactoryListener,
PrettyPrintable {
    private static final TCLogger logger = TCLogging.getLogger(ReplicatedClusterStateManagerImpl.class);
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final ClusterState state;
    private final StateManager stateManager;
    private final ChannelLifeCycleHandler clm;
    private boolean isActive = false;
    private final Collection<NodeID> others = new HashSet<NodeID>();

    public ReplicatedClusterStateManagerImpl(GroupManager<AbstractGroupMessage> groupManager, StateManager stateManager, ClusterState clusterState, ConnectionIDFactory factory, ChannelLifeCycleHandler clm) {
        this.groupManager = groupManager;
        this.stateManager = stateManager;
        this.state = clusterState;
        this.clm = clm;
        groupManager.registerForMessages(ClusterStateMessage.class, this);
        factory.registerForConnectionIDEvents((ConnectionIDFactoryListener)this);
    }

    @Override
    public synchronized void goActiveAndSyncState() {
        this.state.generateStripeIDIfNeeded();
        this.state.syncActiveState();
        this.others.clear();
        this.others.addAll(this.publishToAll((AbstractGroupMessage)ClusterStateMessage.createClusterStateMessage((ClusterState)this.state)));
        this.isActive = true;
        this.notifyAll();
    }

    @Override
    public synchronized void publishClusterState(NodeID nodeID) throws GroupException {
        this.waitUntilActive();
        ClusterStateMessage msg = (ClusterStateMessage)this.groupManager.sendToAndWaitForResponse(nodeID, (AbstractGroupMessage)ClusterStateMessage.createClusterStateMessage((ClusterState)this.state));
        this.validateResponse(nodeID, msg);
    }

    private void waitUntilActive() {
        while (!this.isActive) {
            logger.info((Object)"Waiting since ReplicatedClusterStateManager hasn't gone ACTIVE yet ...");
            try {
                this.wait(3000L);
            }
            catch (InterruptedException e) {
                throw new TCRuntimeException((Throwable)e);
            }
        }
    }

    private boolean validateResponse(NodeID nodeID, ClusterStateMessage msg) {
        if (msg == null || msg.getType() != 255) {
            logger.error((Object)("Recd wrong response from : " + nodeID + " : msg = " + msg + " while publishing Cluster State: Killing the node"));
            this.groupManager.zapNode(nodeID, msg != null && msg.getType() == 254 ? 255 : 2, "Recd wrong response from : " + nodeID + " while publishing Cluster State" + L2HAZapNodeRequestProcessor.getErrorString(new Throwable()));
            return false;
        }
        return true;
    }

    @Override
    public synchronized Iterable<NodeID> getPassives() {
        return new Iterable<NodeID>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<NodeID> iterator() {
                ReplicatedClusterStateManagerImpl replicatedClusterStateManagerImpl = ReplicatedClusterStateManagerImpl.this;
                synchronized (replicatedClusterStateManagerImpl) {
                    return new ArrayList(ReplicatedClusterStateManagerImpl.this.others).iterator();
                }
            }
        };
    }

    public synchronized void connectionIDCreated(ConnectionID connectionID) {
        Assert.assertTrue((boolean)this.stateManager.isActiveCoordinator());
        this.state.addNewConnection(connectionID);
        this.publishToAll((AbstractGroupMessage)ClusterStateMessage.createNewConnectionCreatedMessage((ConnectionID)connectionID));
    }

    public synchronized void connectionIDDestroyed(ConnectionID connectionID) {
        Assert.assertTrue((boolean)this.stateManager.isActiveCoordinator());
        this.state.removeConnection(connectionID);
        this.publishToAll((AbstractGroupMessage)ClusterStateMessage.createConnectionDestroyedMessage((ConnectionID)connectionID));
    }

    private Collection<NodeID> publishToAll(AbstractGroupMessage message) {
        try {
            GroupResponse<AbstractGroupMessage> gr = this.groupManager.sendAllAndWaitForResponse(message);
            HashSet<NodeID> success = new HashSet<NodeID>();
            for (AbstractGroupMessage resp : gr.getResponses()) {
                ClusterStateMessage msg = (ClusterStateMessage)resp;
                if (!this.validateResponse(msg.messageFrom(), msg)) continue;
                success.add(msg.messageFrom());
            }
            return success;
        }
        catch (GroupException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void messageReceived(NodeID fromNode, ClusterStateMessage msg) {
        this.handleClusterStateMessage(fromNode, msg);
    }

    private void handleClusterStateMessage(NodeID fromNode, ClusterStateMessage msg) {
        if (this.stateManager.isActiveCoordinator()) {
            logger.warn((Object)("Recd ClusterStateMessage from " + fromNode + " while I am the cluster co-ordinator. This is bad. Sending NG response. "));
            this.sendNGSplitBrainResponse(fromNode, msg);
            this.groupManager.zapNode(fromNode, 255, "Recd ClusterStateMessage from : " + fromNode + " while in ACTIVE-COORDINATOR state" + L2HAZapNodeRequestProcessor.getErrorString(new Throwable()));
        } else {
            if (msg.isSplitBrainMessage()) {
                return;
            }
            msg.initState(this.state);
            this.state.syncSequenceState();
            this.sendChannelLifeCycleEventsIfNecessary(msg);
            this.sendOKResponse(fromNode, msg);
        }
    }

    private void sendChannelLifeCycleEventsIfNecessary(ClusterStateMessage msg) {
        if (msg.getType() == 1) {
            ClientID nodeID = new ClientID(msg.getConnectionID().getChannelID());
            this.clm.clientCreated(nodeID, msg.getConnectionID().getProductId());
        } else if (msg.getType() == 2) {
            ClientID nodeID = new ClientID(msg.getConnectionID().getChannelID());
            this.clm.clientDropped(nodeID, msg.getConnectionID().getProductId(), false);
        }
    }

    private void sendOKResponse(NodeID fromNode, ClusterStateMessage msg) {
        try {
            this.groupManager.sendTo(fromNode, (AbstractGroupMessage)ClusterStateMessage.createOKResponse((ClusterStateMessage)msg));
        }
        catch (GroupException e) {
            logger.error((Object)("Error handling message : " + msg), (Throwable)e);
        }
    }

    private void sendNGSplitBrainResponse(NodeID fromNode, ClusterStateMessage msg) {
        try {
            this.groupManager.sendTo(fromNode, (AbstractGroupMessage)ClusterStateMessage.createNGSplitBrainResponse((ClusterStateMessage)msg));
        }
        catch (GroupException e) {
            logger.error((Object)("Error handling message : " + msg), (Throwable)e);
        }
    }

    @Override
    public synchronized void setCurrentState(State currentState) {
        this.state.setCurrentState(currentState);
    }

    public synchronized PrettyPrinter prettyPrint(PrettyPrinter out) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(ReplicatedClusterStateManagerImpl.class.getSimpleName() + " [ ");
        strBuilder.append(this.state).append(" ").append(this.stateManager);
        strBuilder.append(" ]");
        out.print((Object)strBuilder.toString());
        return out;
    }
}

