/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.StripeID;
import com.tc.net.groups.StripeIDEventListener;
import com.tc.net.groups.StripeIDStateManager;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class StripeIDStateManagerImpl
implements StripeIDStateManager,
PrettyPrintable {
    private static final TCLogger logger = TCLogging.getLogger(StripeIDStateManagerImpl.class);
    private final CopyOnWriteArrayList<StripeIDEventListener> listeners = new CopyOnWriteArrayList();
    private StripeID stripeID = StripeID.NULL_ID;
    private final AtomicInteger unKnownIDCount = new AtomicInteger(0);
    private final ClusterStatePersistor clusterStatePersistor;

    public StripeIDStateManagerImpl(ClusterStatePersistor clusterStatePersistor) {
        this.clusterStatePersistor = clusterStatePersistor;
        this.unKnownIDCount.set(this.loadStripeIDFromDB());
    }

    private int loadStripeIDFromDB() {
        StripeID id = this.clusterStatePersistor.getStripeID();
        return id.isNull() ? 1 : 0;
    }

    @Override
    public StripeID getStripeID() {
        return this.stripeID;
    }

    @Override
    public boolean isStripeIDMatched(StripeID stripeID) {
        return !stripeID.isNull() && stripeID.equals((Object)this.getStripeID());
    }

    private void putToStore(StripeID stripeID) {
        logger.info((Object)("putToStore " + stripeID));
        this.clusterStatePersistor.setStripeID(stripeID);
    }

    @Override
    public boolean verifyOrSaveStripeID(StripeID stripeID, boolean overwrite) {
        if (stripeID.isNull()) {
            logger.warn((Object)"Ignore null StripeID");
            return false;
        }
        StripeID oldID = this.stripeID;
        if (overwrite || oldID.isNull()) {
            this.putToStore(stripeID);
            if (oldID.isNull()) {
                this.unKnownIDCount.decrementAndGet();
            }
            logger.debug((Object)("Collected " + stripeID + " count: " + this.unKnownIDCount.get()));
            this.notifyLocalStripeIDReady(stripeID);
        } else if (!oldID.equals((Object)stripeID)) {
            logger.error((Object)("Mismatch StripeID " + oldID + " with " + stripeID));
            return false;
        }
        return true;
    }

    private void notifyLocalStripeIDReady(StripeID stripeID) {
        logger.info((Object)"Notify local StripeID ready");
        for (StripeIDEventListener listener : this.listeners) {
            listener.notifyStripeIDCreated(stripeID);
        }
    }

    @Override
    public void registerForStripeIDEvents(StripeIDEventListener listener) {
        this.listeners.add(listener);
        StripeID stripeID = this.getStripeID();
        if (!stripeID.isNull()) {
            listener.notifyStripeIDCreated(stripeID);
        }
        if (this.unKnownIDCount.get() == 0) {
            listener.notifyStripeIDMapReady();
        }
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        out.print((Object)this.getClass().getName()).flush();
        out.print((Object)"stripeID: ").print((Object)this.getStripeID()).flush();
        return out;
    }
}

