/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.ha;

import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class WeightGeneratorFactory {
    private final List<WeightGenerator> generators = new ArrayList<WeightGenerator>();

    public synchronized void add(WeightGenerator g) {
        Assert.assertNotNull((Object)g);
        this.generators.add(g);
    }

    public synchronized long[] generateWeightSequence() {
        long[] weights = new long[this.generators.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = this.generators.get(i).getWeight();
        }
        return weights;
    }

    public synchronized long[] generateMaxWeightSequence() {
        long[] weights = new long[this.generators.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = Long.MAX_VALUE;
        }
        return weights;
    }

    public static interface WeightGenerator {
        public long getWeight();
    }
}

