/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.Sink;
import com.tc.l2.handler.GroupEvent;
import com.tc.net.NodeID;
import com.tc.net.groups.GroupEventsListener;
import java.util.ArrayList;
import java.util.List;

public class GroupEventsDispatchHandler
extends AbstractEventHandler<GroupEvent> {
    private final List<GroupEventsListener> listeners = new ArrayList<GroupEventsListener>();

    public void addListener(GroupEventsListener listener) {
        this.listeners.add(listener);
    }

    public void handleEvent(GroupEvent e) {
        if (e.nodeJoined()) {
            for (GroupEventsListener listener : this.listeners) {
                listener.nodeJoined(e.getNodeID());
            }
        } else {
            for (GroupEventsListener listener : this.listeners) {
                listener.nodeLeft(e.getNodeID());
            }
        }
    }

    public GroupEventsListener createDispatcher(Sink<GroupEvent> sink) {
        return new GroupEventsDispatcher(sink);
    }

    private static final class GroupEventsDispatcher
    implements GroupEventsListener {
        private final Sink<GroupEvent> sink;

        public GroupEventsDispatcher(Sink<GroupEvent> sink) {
            this.sink = sink;
        }

        @Override
        public void nodeJoined(NodeID nodeID) {
            this.sink.addSingleThreaded((Object)new GroupEvent(nodeID, true));
        }

        @Override
        public void nodeLeft(NodeID nodeID) {
            this.sink.addSingleThreaded((Object)new GroupEvent(nodeID, false));
        }
    }
}

