/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.async.impl.StageController;
import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.state.StateManager;
import com.tc.objectserver.core.api.ITopologyEventCollector;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.server.TCServerMain;
import com.tc.util.State;

public class L2StateChangeHandler
extends AbstractEventHandler<StateChangedEvent> {
    private StateManager stateManager;
    private final StageController stageManager;
    private ConfigurationContext context;
    private final ITopologyEventCollector eventCollector;

    public L2StateChangeHandler(StageController stageManager, ITopologyEventCollector eventCollector) {
        this.stageManager = stageManager;
        this.eventCollector = eventCollector;
    }

    public void handleEvent(StateChangedEvent sce) {
        State newState = sce.getCurrentState();
        if (sce.movedToActive()) {
            TCServerMain.getServer().updateActivateTime();
            this.eventCollector.serverDidEnterState(newState, TCServerMain.getServer().getActivateTime());
        } else {
            this.eventCollector.serverDidEnterState(newState, System.currentTimeMillis());
        }
        this.stageManager.transition(this.context, sce.getOldState(), newState);
        this.stateManager.fireStateChangedEvent(sce);
    }

    public void initialize(ConfigurationContext context) {
        super.initialize(context);
        ServerConfigurationContext oscc = (ServerConfigurationContext)context;
        this.stateManager = oscc.getL2Coordinator().getStateManager();
        this.context = context;
    }
}

