/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.l2.msg.PlatformInfoRequest;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.services.LocalMonitoringProducer;
import com.tc.util.Assert;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.terracotta.monitoring.PlatformServer;

public class PlatformInfoRequestHandler {
    private static final TCLogger LOGGER = TCLogging.getLogger(PlatformInfoRequestHandler.class);
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final LocalMonitoringProducer monitoringSupport;
    private final Set<NodeID> knownServer = new HashSet<NodeID>();

    public PlatformInfoRequestHandler(GroupManager<AbstractGroupMessage> groupManager, LocalMonitoringProducer monitoringSupport) {
        Assert.assertNotNull(groupManager);
        Assert.assertNotNull((Object)monitoringSupport);
        this.groupManager = groupManager;
        this.monitoringSupport = monitoringSupport;
    }

    public EventHandler<PlatformInfoRequest> getEventHandler() {
        return new AbstractEventHandler<PlatformInfoRequest>(){

            public void handleEvent(PlatformInfoRequest context) throws EventHandlerException {
                try {
                    switch (context.getType()) {
                        case 1: {
                            PlatformInfoRequestHandler.this.handleRequestEvent(context);
                            break;
                        }
                        case 2: {
                            PlatformInfoRequestHandler.this.handleServerInfo(context);
                            break;
                        }
                        case 6: {
                            PlatformInfoRequestHandler.this.handleServerRemove(context);
                            break;
                        }
                        case 3: {
                            PlatformInfoRequestHandler.this.monitoringSupport.handleRemoteAdd((ServerID)context.messageFrom(), context.getConsumerID(), context.getParents(), context.getNodeName(), context.getNodeValue());
                            break;
                        }
                        case 4: {
                            PlatformInfoRequestHandler.this.monitoringSupport.handleRemoteRemove((ServerID)context.messageFrom(), context.getConsumerID(), context.getParents(), context.getNodeName());
                            break;
                        }
                        case 5: {
                            PlatformInfoRequestHandler.this.monitoringSupport.handleRemoteBestEffortsBatch((ServerID)context.messageFrom(), context.getConsumerIDs(), context.getKeys(), context.getValues());
                            break;
                        }
                    }
                }
                catch (GroupException g) {
                    LOGGER.error((Object)g.getLocalizedMessage());
                }
            }
        };
    }

    private void handleRequestEvent(PlatformInfoRequest context) throws GroupException {
        final NodeID requester = context.messageFrom();
        PlatformInfoRequest serverInfo = PlatformInfoRequest.createServerInfoMessage((Serializable)this.monitoringSupport.getLocalServerInfo());
        this.groupManager.sendTo(requester, (AbstractGroupMessage)serverInfo);
        LocalMonitoringProducer.ActivePipeWrapper pipeWrapper = new LocalMonitoringProducer.ActivePipeWrapper(){

            @Override
            public void addNode(long consumerID, String[] parents, String name, Serializable value) {
                PlatformInfoRequest message = PlatformInfoRequest.createAddNode((long)consumerID, (String[])parents, (String)name, (Serializable)value);
                try {
                    PlatformInfoRequestHandler.this.groupManager.sendTo(requester, message);
                }
                catch (GroupException e) {
                    LOGGER.error((Object)e.getLocalizedMessage());
                }
            }

            @Override
            public void removeNode(long consumerID, String[] parents, String name) {
                PlatformInfoRequest message = PlatformInfoRequest.createRemoveNode((long)consumerID, (String[])parents, (String)name);
                try {
                    PlatformInfoRequestHandler.this.groupManager.sendTo(requester, message);
                }
                catch (GroupException e) {
                    LOGGER.error((Object)e.getLocalizedMessage());
                }
            }

            @Override
            public void pushBestEffortsBatch(long[] consumerIDs, String[] keys, Serializable[] values) {
                PlatformInfoRequest message = PlatformInfoRequest.createBestEffortsBatch((long[])consumerIDs, (String[])keys, (Serializable[])values);
                try {
                    PlatformInfoRequestHandler.this.groupManager.sendTo(requester, message);
                }
                catch (GroupException e) {
                    LOGGER.error((Object)e.getLocalizedMessage());
                }
            }
        };
        this.monitoringSupport.sendToNewActive(pipeWrapper);
    }

    private void handleServerInfo(PlatformInfoRequest msg) throws GroupException {
        ServerID sender = (ServerID)msg.messageFrom();
        PlatformServer platformServer = (PlatformServer)msg.getServerInfo();
        if (this.knownServer.add((NodeID)sender)) {
            this.monitoringSupport.serverDidJoinStripe(sender, platformServer);
        }
    }

    private void handleServerRemove(PlatformInfoRequest msg) throws GroupException {
        ServerID sender = (ServerID)msg.messageFrom();
        if (this.knownServer.remove(sender)) {
            this.monitoringSupport.serverDidLeaveStripe(sender);
        }
    }
}

