/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.logging;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class BufferingAppender
extends AppenderSkeleton {
    private final BlockingQueue<LoggingEvent> buffer;
    private boolean on;

    public BufferingAppender(int maxCapacity) {
        this.buffer = new ArrayBlockingQueue<LoggingEvent>(maxCapacity);
        this.on = true;
    }

    protected synchronized void append(LoggingEvent event) {
        if (this.on) {
            this.buffer.offer(event);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAndSendContentsTo(Appender otherAppender) {
        LoggingEvent event;
        BufferingAppender bufferingAppender = this;
        synchronized (bufferingAppender) {
            this.on = false;
        }
        while ((event = (LoggingEvent)this.buffer.poll()) != null) {
            otherAppender.doAppend(event);
        }
    }
}

