/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.logging;

import com.tc.util.Assert;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class DelegatingAppender
implements Appender {
    private Appender delegate;

    public DelegatingAppender(Appender delegate) {
        Assert.assertNotNull((Object)delegate);
        this.delegate = delegate;
    }

    private synchronized Appender delegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDelegate() {
        Appender prev;
        DelegatingAppender delegatingAppender = this;
        synchronized (delegatingAppender) {
            prev = this.delegate;
            this.delegate = new AppenderSkeleton(){

                public boolean requiresLayout() {
                    return false;
                }

                public void close() {
                }

                protected void append(LoggingEvent loggingevent) {
                }

                public synchronized void doAppend(LoggingEvent event) {
                }

                public void finalize() {
                }
            };
        }
        prev.close();
    }

    public synchronized Appender setDelegate(Appender delegate) {
        Assert.assertNotNull((Object)delegate);
        Appender out = this.delegate;
        this.delegate = delegate;
        return out;
    }

    public void addFilter(Filter arg0) {
        this.delegate().addFilter(arg0);
    }

    public void clearFilters() {
        this.delegate().clearFilters();
    }

    public void close() {
        this.closeDelegate();
    }

    public void doAppend(LoggingEvent arg0) {
        this.delegate().doAppend(arg0);
    }

    public ErrorHandler getErrorHandler() {
        return this.delegate().getErrorHandler();
    }

    public Filter getFilter() {
        return this.delegate().getFilter();
    }

    public Layout getLayout() {
        return this.delegate().getLayout();
    }

    public String getName() {
        return this.delegate().getName();
    }

    public boolean requiresLayout() {
        return this.delegate().requiresLayout();
    }

    public void setErrorHandler(ErrorHandler arg0) {
        this.delegate().setErrorHandler(arg0);
    }

    public void setLayout(Layout arg0) {
        this.delegate().setLayout(arg0);
    }

    public void setName(String arg0) {
        this.delegate().setName(arg0);
    }
}

