/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.logging;

import com.tc.logging.LogLevel;
import com.tc.util.Assert;
import org.apache.log4j.Level;

public class LogLevelImpl
implements LogLevel {
    static final int LEVEL_DEBUG = 5;
    static final int LEVEL_INFO = 4;
    static final int LEVEL_WARN = 3;
    static final int LEVEL_ERROR = 2;
    static final int LEVEL_FATAL = 1;
    static final int LEVEL_OFF = 0;
    public static final LogLevel DEBUG = new LogLevelImpl(5);
    public static final LogLevel INFO = new LogLevelImpl(4);
    public static final LogLevel WARN = new LogLevelImpl(3);
    public static final LogLevel ERROR = new LogLevelImpl(2);
    public static final LogLevel FATAL = new LogLevelImpl(1);
    public static final LogLevel OFF = new LogLevelImpl(0);
    public static final String DEBUG_NAME = "DEBUG";
    public static final String INFO_NAME = "INFO";
    public static final String WARN_NAME = "WARN";
    public static final String ERROR_NAME = "ERROR";
    public static final String FATAL_NAME = "FATAL";
    public static final String OFF_NAME = "OFF";
    private final int level;

    private LogLevelImpl(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isInfo() {
        return this.level == 4;
    }

    static Level toLog4JLevel(LogLevel level) {
        if (level == null) {
            return null;
        }
        switch (level.getLevel()) {
            case 5: {
                return Level.DEBUG;
            }
            case 4: {
                return Level.INFO;
            }
            case 3: {
                return Level.WARN;
            }
            case 2: {
                return Level.ERROR;
            }
            case 1: {
                return Level.FATAL;
            }
            case 0: {
                return Level.OFF;
            }
        }
        throw Assert.failure((Object)("Logic Error: Invalid Level: " + level));
    }

    static LogLevel fromLog4JLevel(Level level) {
        if (level == null) {
            return null;
        }
        switch (level.toInt()) {
            case 10000: {
                return DEBUG;
            }
            case 20000: {
                return INFO;
            }
            case 30000: {
                return WARN;
            }
            case 40000: {
                return ERROR;
            }
            case 50000: {
                return FATAL;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
        }
        throw Assert.failure((Object)("Unsupported Level" + level));
    }

    public String toString() {
        switch (this.getLevel()) {
            case 5: {
                return DEBUG_NAME;
            }
            case 4: {
                return INFO_NAME;
            }
            case 3: {
                return WARN_NAME;
            }
            case 2: {
                return ERROR_NAME;
            }
            case 1: {
                return FATAL_NAME;
            }
            case 0: {
                return OFF_NAME;
            }
        }
        return "Unknown";
    }
}

