/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.logging;

import com.tc.l2.logging.LogLevelImpl;
import com.tc.logging.LogLevel;
import com.tc.logging.TCLogger;
import org.apache.log4j.Logger;

class TCLoggerImpl
implements TCLogger {
    private final Logger logger;

    TCLoggerImpl(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Logger name cannot be null");
        }
        this.logger = Logger.getLogger((String)name);
    }

    Logger getLogger() {
        return this.logger;
    }

    public void debug(Object message) {
        if (message instanceof Throwable) {
            this.debug("Exception thrown", (Throwable)message);
        } else {
            this.logger.debug(message);
        }
    }

    public void debug(Object message, Throwable t) {
        this.logger.debug(message, t);
    }

    public void error(Object message) {
        if (message instanceof Throwable) {
            this.error("Exception thrown", (Throwable)message);
        } else {
            this.logger.error(message);
        }
    }

    public void error(Object message, Throwable t) {
        this.logger.error(message, t);
    }

    public void fatal(Object message) {
        if (message instanceof Throwable) {
            this.fatal("Exception thrown", (Throwable)message);
        } else {
            this.logger.fatal(message);
        }
    }

    public void fatal(Object message, Throwable t) {
        this.logger.fatal(message, t);
    }

    public void info(Object message) {
        if (message instanceof Throwable) {
            this.info("Exception thrown", (Throwable)message);
        } else {
            this.logger.info(message);
        }
    }

    public void info(Object message, Throwable t) {
        this.logger.info(message, t);
    }

    public void warn(Object message) {
        if (message instanceof Throwable) {
            this.warn("Exception thrown", (Throwable)message);
        } else {
            this.logger.warn(message);
        }
    }

    public void warn(Object message, Throwable t) {
        this.logger.warn(message, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void setLevel(LogLevel level) {
        this.logger.setLevel(LogLevelImpl.toLog4JLevel(level));
    }

    public LogLevel getLevel() {
        return LogLevelImpl.fromLog4JLevel(this.logger.getLevel());
    }

    public String getName() {
        return this.logger.getName();
    }
}

