/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.logging;

import com.tc.l2.logging.BufferingAppender;
import com.tc.l2.logging.DelegatingAppender;
import com.tc.l2.logging.Log4JAppenderToTCAppender;
import com.tc.l2.logging.Log4jSafeInit;
import com.tc.l2.logging.TCConsoleAppender;
import com.tc.l2.logging.TCLoggerImpl;
import com.tc.l2.logging.TCRollingFileAppender;
import com.tc.logging.TCAppender;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLoggingService;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.ProductInfo;
import com.tc.util.io.FileUtils;
import com.tc.util.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.varia.NullAppender;

public class TCLoggingLog4J
implements TCLoggingService {
    private static final String TERRACOTTA_L1_LOG_FILE_NAME = "terracotta-client.log";
    private static final String TERRACOTTA_L2_LOG_FILE_NAME = "terracotta-server.log";
    private static final String TERRACOTTA_GENERIC_LOG_FILE_NAME = "terracotta-generic.log";
    private static final int MAX_BUFFERED_LOG_MESSAGES = 10000;
    private static final String MAX_LOG_FILE_SIZE_PROPERTY = "maxLogFileSize";
    private static final int DEFAULT_MAX_LOG_FILE_SIZE = 512;
    private static final String MAX_BACKUPS_PROPERTY = "maxBackups";
    private static final int DEFAULT_MAX_BACKUPS = 20;
    private static final String LOG4J_CUSTOM_FILENAME = ".tc.custom.log4j.properties";
    public static final String LOG4J_PROPERTIES_FILENAME = ".tc.dev.log4j.properties";
    private static final String CONSOLE_PATTERN = "%d %p - %m%n";
    public static final String DUMP_PATTERN = "[dump] %m%n";
    public static final String DERBY_PATTERN = "[derby.log] %m%n";
    private static final String CONSOLE_PATTERN_DEVELOPMENT = "%d [%t] %p %c - %m%n";
    private static final String CONSOLE_LOGGING_ONLY_PATTERN = "[TC] %d %p - %m%n";
    public static final String FILE_AND_JMX_PATTERN = "%d [%t] %p %c - %m%n";
    private static final String CUSTOMER_LOGGER_NAMESPACE = "com.terracottatech";
    private static final String CUSTOMER_LOGGER_NAMESPACE_WITH_DOT = "com.terracottatech.";
    private static final String CONSOLE_LOGGER_NAME = "com.terracottatech.console";
    private static final String OPERATOR_EVENT_LOGGER_NAME = "tc.operator.event";
    public static final String DUMP_LOGGER_NAME = "com.tc.dumper.dump";
    public static final String LOG_CONFIGURATION_PREFIX = "The configuration read for Logging: ";
    private static final String[] INTERNAL_LOGGER_NAMESPACES = new String[]{"com", "org", "tc.operator"};
    private static final String LOCK_FILE_NAME = ".terracotta-logging.lock";
    private static final TCLogger console;
    private static final TCLogger operatorEventLogger;
    private static final Appender consoleAppender;
    private static final Logger[] allLoggers;
    private static final DelegatingAppender delegateFileAppender;
    private static final DelegatingAppender delegateBufferingAppender;
    private static boolean buffering;
    private File currentLoggingDirectory = null;
    private FileLock currentLoggingDirectoryFileLock = null;
    private boolean lockingDisabled = false;
    private static Properties loggingProperties;
    public static final int PROCESS_TYPE_GENERIC = 0;
    public static final int PROCESS_TYPE_L1 = 1;
    public static final int PROCESS_TYPE_L2 = 2;

    public TCLogger getLogger(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return this.getLogger(clazz.getName());
    }

    public TCLogger getLogger(String name) {
        if (name == null) {
            throw new NullPointerException("Logger cannot be null");
        }
        boolean allowedName = false;
        for (String namespace : INTERNAL_LOGGER_NAMESPACES) {
            String withDot = namespace + ".";
            if (!name.startsWith(withDot)) continue;
            allowedName = true;
            break;
        }
        if (!allowedName) {
            throw new IllegalArgumentException("Logger name (" + name + ") not in valid namespace: " + Arrays.asList(INTERNAL_LOGGER_NAMESPACES));
        }
        return new TCLoggerImpl(name);
    }

    public TCLogger getTestingLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return new TCLoggerImpl(name);
    }

    public TCLogger getCustomerLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        name = CUSTOMER_LOGGER_NAMESPACE_WITH_DOT + name;
        if (CONSOLE_LOGGER_NAME.equals(name)) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        return new TCLoggerImpl(name);
    }

    public TCLogger getConsoleLogger() {
        return console;
    }

    public TCLogger getOperatorEventLogger() {
        return operatorEventLogger;
    }

    private static void reportLoggingError(Exception e) {
        TCLoggingLog4J.reportLoggingError(null, e);
    }

    private static void reportLoggingError(String message, Exception e) {
        String newLine = System.getProperty("line.separator");
        StringBuffer errorMsg = new StringBuffer(newLine);
        if (message != null) {
            errorMsg.append("WARN: ").append(message).append(newLine);
        }
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            errorMsg.append(sw.toString());
        }
        System.err.println(errorMsg.toString());
    }

    private static boolean developmentConfiguration() {
        try {
            ArrayList<InputStream> configStreams = new ArrayList<InputStream>();
            File[] devLoggingLocations = new File[]{new File(System.getProperty("user.home"), LOG4J_PROPERTIES_FILENAME), new File(System.getProperty("user.dir"), LOG4J_PROPERTIES_FILENAME)};
            InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(LOG4J_PROPERTIES_FILENAME);
            if (stream != null) {
                configStreams.add(stream);
            }
            for (File propFile : devLoggingLocations) {
                if (!propFile.isFile() || !propFile.canRead()) continue;
                configStreams.add(new FileInputStream(propFile));
            }
            Properties developerProps = TCLoggingLog4J.layerDevelopmentConfiguration(configStreams);
            if (developerProps != null) {
                Logger.getRootLogger().setLevel(Level.INFO);
                PropertyConfigurator.configure((Properties)developerProps);
                loggingProperties = developerProps;
                return true;
            }
        }
        catch (Exception e) {
            TCLoggingLog4J.reportLoggingError(e);
        }
        return false;
    }

    static Properties layerDevelopmentConfiguration(Collection<? extends InputStream> list) {
        if (list.isEmpty()) {
            return null;
        }
        Properties isDev = new Properties();
        for (InputStream inputStream : list) {
            try {
                isDev.load(inputStream);
            }
            catch (IOException ioe) {
                TCLoggingLog4J.reportLoggingError(ioe);
            }
        }
        return isDev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean customConfiguration() {
        try {
            ArrayList<File> locations = new ArrayList<File>();
            if (System.getenv("TC_INSTALL_DIR") != null) {
                locations.add(new File(System.getenv("TC_INSTALL_DIR"), LOG4J_CUSTOM_FILENAME));
            }
            locations.add(new File(System.getProperty("user.home"), LOG4J_CUSTOM_FILENAME));
            locations.add(new File(System.getProperty("user.dir"), LOG4J_CUSTOM_FILENAME));
            for (File propFile : locations) {
                if (!propFile.isFile() || !propFile.canRead()) continue;
                Properties properties = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(propFile);
                    properties.load(fis);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
                PropertyConfigurator.configure((Properties)properties);
                loggingProperties = properties;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            TCLoggingLog4J.reportLoggingError(e);
            return false;
        }
    }

    public synchronized void disableLocking() {
        this.lockingDisabled = true;
        if (this.currentLoggingDirectoryFileLock != null) {
            try {
                this.currentLoggingDirectoryFileLock.release();
                this.currentLoggingDirectoryFileLock.channel().close();
                this.currentLoggingDirectoryFileLock = null;
            }
            catch (IOException ioe) {
                throw Assert.failure((Object)"Unable to release file lock?", (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogDirectory(File theDirectory, int processType) {
        Assert.assertNotNull((Object)theDirectory);
        if (theDirectory.getName().trim().equalsIgnoreCase("stdout:") || theDirectory.getName().trim().equalsIgnoreCase("stderr:")) {
            if (this.currentLoggingDirectory != null && this.currentLoggingDirectory.getName().trim().equalsIgnoreCase(theDirectory.getName())) {
                return;
            }
            delegateFileAppender.setDelegate((Appender)new NullAppender());
            consoleAppender.setLayout((Layout)new PatternLayout(CONSOLE_LOGGING_ONLY_PATTERN));
            Logger.getRootLogger().addAppender(consoleAppender);
            if (buffering) {
                BufferingAppender realBufferingAppender = (BufferingAppender)delegateBufferingAppender.setDelegate((Appender)new NullAppender());
                realBufferingAppender.stopAndSendContentsTo(consoleAppender);
                realBufferingAppender.close();
                buffering = false;
            }
            boolean stdout = theDirectory.getName().trim().equalsIgnoreCase("stdout:");
            this.getConsoleLogger().info((Object)("All logging information now output to standard " + (stdout ? "output" : "error") + "."));
            return;
        }
        Class<TCLoggingLog4J> stdout = TCLoggingLog4J.class;
        synchronized (TCLoggingLog4J.class) {
            String logFileName;
            if (this.currentLoggingDirectory != null) {
                try {
                    if (theDirectory.getCanonicalPath().equals(this.currentLoggingDirectory.getCanonicalPath())) {
                        // ** MonitorExit[stdout] (shouldn't be in output)
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[stdout] (shouldn't be in output)
            try {
                FileUtils.forceMkdir((File)theDirectory);
            }
            catch (IOException ioe) {
                TCLoggingLog4J.reportLoggingError("We can't create the directory '" + theDirectory.getAbsolutePath() + "' that you specified for your logs.", ioe);
                return;
            }
            if (!theDirectory.canWrite()) {
                TCLoggingLog4J.reportLoggingError("The log directory, '" + theDirectory.getAbsolutePath() + "', can't be written to.", null);
                return;
            }
            FileLock thisDirectoryLock = null;
            if (!this.lockingDisabled) {
                File lockFile = new File(theDirectory, LOCK_FILE_NAME);
                try {
                    lockFile.createNewFile();
                    Assert.eval((boolean)lockFile.exists());
                    FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
                    thisDirectoryLock = channel.tryLock();
                    if (thisDirectoryLock == null) {
                        TCLoggingLog4J.reportLoggingError("The log directory, '" + theDirectory.getAbsolutePath() + "', is already in use by another Terracotta process. Logging will proceed to the console only.", null);
                        return;
                    }
                }
                catch (OverlappingFileLockException channel) {
                }
                catch (IOException ioe) {
                    TCLoggingLog4J.reportLoggingError("We can't lock the file '" + lockFile.getAbsolutePath() + "', to make sure that only one Terracotta process is using this directory for logging. This may be a permission issue, or some unexpected error. Logging will proceed to the console only.", ioe);
                    return;
                }
            }
            switch (processType) {
                case 1: {
                    logFileName = TERRACOTTA_L1_LOG_FILE_NAME;
                    break;
                }
                case 2: {
                    logFileName = TERRACOTTA_L2_LOG_FILE_NAME;
                    break;
                }
                case 0: {
                    logFileName = TERRACOTTA_GENERIC_LOG_FILE_NAME;
                    break;
                }
                default: {
                    throw Assert.failure((Object)("Unknown process type: " + processType));
                }
            }
            String logFilePath = new File(theDirectory, logFileName).getAbsolutePath();
            Class<TCLoggingLog4J> clazz = TCLoggingLog4J.class;
            synchronized (TCLoggingLog4J.class) {
                try {
                    TCProperties props = TCPropertiesImpl.getProperties().getPropertiesFor("logging");
                    TCRollingFileAppender newFileAppender = new TCRollingFileAppender((Layout)new PatternLayout("%d [%t] %p %c - %m%n"), logFilePath, true);
                    newFileAppender.setName("file appender");
                    int maxLogFileSize = props.getInt(MAX_LOG_FILE_SIZE_PROPERTY, 512);
                    newFileAppender.setMaxFileSize(maxLogFileSize + "MB");
                    newFileAppender.setMaxBackupIndex(props.getInt(MAX_BACKUPS_PROPERTY, 20));
                    newFileAppender.rollOver();
                    Appender oldFileAppender = delegateFileAppender.setDelegate((Appender)newFileAppender);
                    if (oldFileAppender != null) {
                        oldFileAppender.close();
                    }
                    if (buffering) {
                        BufferingAppender realBufferingAppender = (BufferingAppender)delegateBufferingAppender.setDelegate((Appender)new NullAppender());
                        realBufferingAppender.stopAndSendContentsTo(delegateFileAppender);
                        realBufferingAppender.close();
                        buffering = false;
                    }
                    this.currentLoggingDirectory = theDirectory;
                    if (this.currentLoggingDirectoryFileLock != null) {
                        this.currentLoggingDirectoryFileLock.release();
                    }
                    this.currentLoggingDirectoryFileLock = thisDirectoryLock;
                }
                catch (IOException ioe) {
                    TCLoggingLog4J.reportLoggingError("We were unable to switch the logging system to log to '" + logFilePath + "'.", ioe);
                }
                this.getConsoleLogger().info((Object)("Log file: '" + logFilePath + "'."));
                this.writeSystemProperties();
                return;
            }
        }
    }

    public TCLogger getDumpLogger() {
        return new TCLoggerImpl(DUMP_LOGGER_NAME);
    }

    public Log4JAppenderToTCAppender addAppender(String loggerName, TCAppender appender) {
        Log4JAppenderToTCAppender wrappedAppender = new Log4JAppenderToTCAppender(appender);
        new TCLoggerImpl(loggerName).getLogger().addAppender((Appender)wrappedAppender);
        return wrappedAppender;
    }

    private static Logger[] createAllLoggerList(List<Logger> internalLoggers, Logger customerLogger) {
        ArrayList<Logger> loggers = new ArrayList<Logger>();
        loggers.addAll(internalLoggers);
        return loggers.toArray(new Logger[0]);
    }

    public static void addToAllLoggers(Appender appender) {
        for (Logger allLogger : allLoggers) {
            allLogger.addAppender(appender);
        }
    }

    private static void writeVersion() {
        ProductInfo info = ProductInfo.getInstance();
        TCLogger consoleLogger = console;
        String longProductString = info.toLongString();
        consoleLogger.info((Object)longProductString);
        if (info.isPatched()) {
            String longPatchString = info.toLongPatchString();
            consoleLogger.info((Object)longPatchString);
        }
    }

    private static void writePID() {
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            long pid = Long.parseLong(processName.split("@")[0]);
            console.info((Object)("PID is " + pid));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void writeSystemProperties() {
        try {
            Properties properties = System.getProperties();
            int maxKeyLength = 1;
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object objKey = entry.getKey();
                Object objValue = entry.getValue();
                if (!(objKey instanceof String) || !(objValue instanceof String)) continue;
                String key = (String)objKey;
                keys.add(key);
                maxKeyLength = Math.max(maxKeyLength, key.length());
            }
            String inputArguments = null;
            try {
                RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
                inputArguments = mxbean.getInputArguments().toString();
            }
            catch (SecurityException se) {
                inputArguments = "unknown";
            }
            String nl = System.getProperty("line.separator");
            StringBuffer data = new StringBuffer();
            data.append("All Java System Properties for this Terracotta instance:");
            data.append(nl);
            data.append("========================================================================");
            data.append(nl);
            data.append("JVM arguments: " + inputArguments);
            data.append(nl);
            Object[] sortedKeys = keys.toArray(new String[keys.size()]);
            Arrays.sort(sortedKeys);
            for (Object key : sortedKeys) {
                data.append((String)key);
                for (int i = 0; i < maxKeyLength - ((String)key).length(); ++i) {
                    data.append(' ');
                }
                data.append(" : ");
                data.append(properties.get(key));
                data.append(nl);
            }
            data.append("========================================================================");
            this.getLogger(TCLoggingLog4J.class).info((Object)data.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void closeFileAppender() {
        if (delegateFileAppender != null) {
            delegateFileAppender.close();
        }
    }

    private static void writeLoggingConfigurations() {
        if (loggingProperties != null) {
            new TCLoggerImpl(TCLoggingLog4J.class.getName()).info(LOG_CONFIGURATION_PREFIX + loggingProperties);
        }
    }

    public void setLogLocationAndType(URI location, int processType) {
        this.setLogDirectory(new File(location), processType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(TCLoggingLog4J.class.getClassLoader());
        Log4jSafeInit.init();
        Logger customerLogger = Logger.getLogger((String)CUSTOMER_LOGGER_NAMESPACE);
        Logger consoleLogger = Logger.getLogger((String)CONSOLE_LOGGER_NAME);
        console = new TCLoggerImpl(CONSOLE_LOGGER_NAME);
        consoleAppender = new TCConsoleAppender(new PatternLayout(CONSOLE_PATTERN), "System.out");
        operatorEventLogger = new TCLoggerImpl(OPERATOR_EVENT_LOGGER_NAME);
        ArrayList<Logger> internalLoggers = new ArrayList<Logger>();
        for (String nameSpace : INTERNAL_LOGGER_NAMESPACES) {
            internalLoggers.add(Logger.getLogger((String)nameSpace));
        }
        allLoggers = TCLoggingLog4J.createAllLoggerList(internalLoggers, customerLogger);
        try {
            boolean isDev;
            boolean customLogging = TCLoggingLog4J.customConfiguration();
            boolean bl = isDev = customLogging ? false : TCLoggingLog4J.developmentConfiguration();
            if (!customLogging) {
                for (Logger internalLogger : internalLoggers) {
                    internalLogger.setLevel(Level.INFO);
                }
                customerLogger.setLevel(Level.INFO);
                consoleLogger.setLevel(Level.INFO);
                if (!isDev) {
                    consoleLogger.addAppender(consoleAppender);
                } else {
                    consoleAppender.setLayout((Layout)new PatternLayout("%d [%t] %p %c - %m%n"));
                    Logger.getRootLogger().addAppender(consoleAppender);
                }
            }
            delegateFileAppender = new DelegatingAppender((Appender)new NullAppender());
            TCLoggingLog4J.addToAllLoggers(delegateFileAppender);
            BufferingAppender realBufferingAppender = new BufferingAppender(10000);
            realBufferingAppender.setName("buffering appender");
            delegateBufferingAppender = new DelegatingAppender((Appender)realBufferingAppender);
            TCLoggingLog4J.addToAllLoggers(delegateBufferingAppender);
            buffering = true;
            if (!isDev) {
                console.info((Object)"New logging session started.");
            }
            TCLoggingLog4J.writeVersion();
            TCLoggingLog4J.writePID();
            TCLoggingLog4J.writeLoggingConfigurations();
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }
}

