/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.logging;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class TCRollingFileAppender
extends RollingFileAppender {
    private static final PatternLayout DUMP_PATTERN_LAYOUT = new PatternLayout("[dump] %m%n");
    private String fileNamePrefix = "";
    private String fileNameSuffix = "";

    public TCRollingFileAppender(Layout layout, String logPath, boolean append) throws IOException {
        super(layout, logPath, append);
        int index = logPath.lastIndexOf(46);
        if (index != -1) {
            this.fileNamePrefix = logPath.substring(0, index);
            this.fileNameSuffix = logPath.substring(index);
        } else {
            this.fileNamePrefix = logPath;
        }
    }

    public void subAppend(LoggingEvent event) {
        Layout prevLayout = this.getLayout();
        try {
            if (event.getLoggerName().equals("com.tc.dumper.dump")) {
                this.setLayout((Layout)DUMP_PATTERN_LAYOUT);
            }
            super.subAppend(event);
        }
        finally {
            this.setLayout(prevLayout);
        }
    }

    public void rollOver() {
        if (this.qw != null) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug((String)("rolling over count=" + size));
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        boolean renameSucceeded = true;
        if (this.maxBackupIndex > 0) {
            File target;
            File file = new File(this.fileNamePrefix + '.' + this.maxBackupIndex + this.fileNameSuffix);
            if (file.exists()) {
                renameSucceeded = file.delete();
            }
            for (int i = this.maxBackupIndex - 1; i >= 1 && renameSucceeded; --i) {
                file = new File(this.fileNamePrefix + "." + i + this.fileNameSuffix);
                if (!file.exists()) continue;
                target = new File(this.fileNamePrefix + '.' + (i + 1) + this.fileNameSuffix);
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                renameSucceeded = file.renameTo(target);
            }
            if (renameSucceeded) {
                target = new File(this.fileNamePrefix + "." + 1 + this.fileNameSuffix);
                this.closeFile();
                file = new File(this.fileName);
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                renameSucceeded = file.renameTo(target);
                if (!renameSucceeded) {
                    try {
                        this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                    }
                    catch (IOException e) {
                        if (e instanceof InterruptedIOException) {
                            Thread.currentThread().interrupt();
                        }
                        LogLog.error((String)("setFile(" + this.fileName + ", true) call failed."), (Throwable)e);
                    }
                }
            }
        }
        if (renameSucceeded) {
            try {
                this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
            }
        }
    }
}

