/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.operatorevent;

import com.tc.config.NodesStore;
import com.tc.management.TSAManagementEventPayload;
import com.tc.management.TerracottaRemoteManagement;
import com.tc.net.ServerID;
import com.tc.operatorevent.TerracottaOperatorEventFactory;
import com.tc.operatorevent.TerracottaOperatorEventLogger;
import com.tc.operatorevent.TerracottaOperatorEventLogging;

public class OperatorEventsPassiveServerConnectionListener {
    private final TerracottaOperatorEventLogger operatorEventLogger = TerracottaOperatorEventLogging.getEventLogger();
    private final NodesStore nodesStore;

    public OperatorEventsPassiveServerConnectionListener(NodesStore nodesStore) {
        this.nodesStore = nodesStore;
    }

    public void passiveServerJoined(ServerID nodeID) {
    }

    public void passiveServerLeft(ServerID nodeID) {
        String serverName = this.nodesStore.getServerNameFromNodeName(nodeID.getName());
        if (serverName == null) {
            serverName = nodeID.getName();
        }
        TSAManagementEventPayload tsaManagementEventPayload = new TSAManagementEventPayload("TSA.TOPOLOGY.MIRROR_LEFT");
        tsaManagementEventPayload.getAttributes().put("Server.Name", serverName);
        TerracottaRemoteManagement.getRemoteManagementInstance().sendEvent(tsaManagementEventPayload.toManagementEvent());
        this.operatorEventLogger.fireOperatorEvent(TerracottaOperatorEventFactory.createPassiveL2DisconnectedEvent((String)serverName));
    }
}

