/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.state.StateChangeListener;
import com.tc.l2.state.StateManager;
import com.tc.net.NodeID;
import com.tc.util.State;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DummyStateManager
implements StateManager {
    private final List<StateChangeListener> stateListeners = new CopyOnWriteArrayList<StateChangeListener>();
    private final NodeID localNodeID;

    public DummyStateManager(NodeID localNodeID) {
        this.localNodeID = localNodeID;
    }

    @Override
    public void fireStateChangedEvent(StateChangedEvent sce) {
        Iterator<StateChangeListener> iterator = this.stateListeners.iterator();
        while (iterator.hasNext()) {
            StateChangeListener element;
            StateChangeListener listener = element = iterator.next();
            listener.l2StateChanged(sce);
        }
    }

    @Override
    public State getCurrentState() {
        return new State("NO_STATE");
    }

    @Override
    public boolean isActiveCoordinator() {
        return true;
    }

    public boolean isPassiveUnitialized() {
        return false;
    }

    @Override
    public void registerForStateChangeEvents(StateChangeListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void moveToPassiveSyncing(NodeID connectedTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startElection() {
        this.fireStateChangedEvent(new StateChangedEvent(StateManager.PASSIVE_STANDBY, StateManager.ACTIVE_COORDINATOR));
    }

    @Override
    public void publishActiveState(NodeID nodeID) {
    }

    @Override
    public void startElectionIfNecessary(NodeID disconnectedNode) {
    }

    @Override
    public void moveToPassiveStandbyState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleClusterStateMessage(L2StateMessage clusterMsg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeID getActiveNodeID() {
        return this.localNodeID;
    }

    @Override
    public void cleanupKnownServers() {
    }
}

