/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.state.StateChangeListener;
import com.tc.net.NodeID;
import com.tc.net.groups.GroupException;
import com.tc.util.State;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface StateManager {
    public static final State ACTIVE_COORDINATOR = new State("ACTIVE-COORDINATOR");
    public static final State RECOVERING = new State("RECOVERING");
    public static final State PASSIVE_UNINITIALIZED = new State("PASSIVE-UNINITIALIZED");
    public static final State PASSIVE_SYNCING = new State("PASSIVE-SYNCING");
    public static final State PASSIVE_STANDBY = new State("PASSIVE-STANDBY");
    public static final State START_STATE = new State("START-STATE");
    public static final State STOP_STATE = new State("STOP-STATE");
    public static final List<State> VALID_STATES = Collections.unmodifiableList(Arrays.asList(START_STATE, PASSIVE_UNINITIALIZED, PASSIVE_SYNCING, PASSIVE_STANDBY, ACTIVE_COORDINATOR, STOP_STATE, RECOVERING));
    public static final List<State> PASSIVE_STATES = Collections.unmodifiableList(Arrays.asList(PASSIVE_UNINITIALIZED, PASSIVE_SYNCING, PASSIVE_STANDBY));

    public void startElection();

    public State getCurrentState();

    public void startElectionIfNecessary(NodeID var1);

    public void registerForStateChangeEvents(StateChangeListener var1);

    public void fireStateChangedEvent(StateChangedEvent var1);

    public boolean isActiveCoordinator();

    public void moveToPassiveSyncing(NodeID var1);

    public void moveToPassiveStandbyState();

    public void publishActiveState(NodeID var1) throws GroupException;

    public void handleClusterStateMessage(L2StateMessage var1);

    public NodeID getActiveNodeID();

    public void cleanupKnownServers();
}

