/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.async.api.Sink;
import com.tc.async.api.StageManager;
import com.tc.exception.TCServerRestartException;
import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.ha.L2HAZapNodeRequestProcessor;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.state.ElectionContext;
import com.tc.l2.state.ElectionManagerImpl;
import com.tc.l2.state.Enrollment;
import com.tc.l2.state.EnrollmentFactory;
import com.tc.l2.state.StateChangeListener;
import com.tc.l2.state.StateManager;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.TSAManagementEventPayload;
import com.tc.management.TerracottaRemoteManagement;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.operatorevent.TerracottaOperatorEventFactory;
import com.tc.operatorevent.TerracottaOperatorEventLogger;
import com.tc.operatorevent.TerracottaOperatorEventLogging;
import com.tc.util.Assert;
import com.tc.util.State;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class StateManagerImpl
implements StateManager {
    private static final TCLogger logger = TCLogging.getLogger(StateManagerImpl.class);
    private final TCLogger consoleLogger;
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final ElectionManagerImpl electionMgr;
    private final Sink<StateChangedEvent> stateChangeSink;
    private final Sink<ElectionContext> electionSink;
    private final WeightGeneratorFactory weightsFactory;
    private final CopyOnWriteArrayList<StateChangeListener> listeners = new CopyOnWriteArrayList();
    private volatile boolean initiated;
    private final ClusterStatePersistor clusterStatePersistor;
    private NodeID activeNode = ServerID.NULL_ID;
    private NodeID syncdTo = ServerID.NULL_ID;
    private volatile State state = START_STATE;
    private State startState = null;
    private final ElectionGate elections = new ElectionGate();
    TerracottaOperatorEventLogger operatorEventLogger = TerracottaOperatorEventLogging.getEventLogger();
    Set<NodeID> prevKnownServers = new HashSet<NodeID>();
    Set<NodeID> currKnownServers = new HashSet<NodeID>();

    public StateManagerImpl(TCLogger consoleLogger, GroupManager<AbstractGroupMessage> groupManager, Sink<StateChangedEvent> stateChangeSink, StageManager mgr, int expectedServers, int electionTimeInSec, WeightGeneratorFactory weightFactory, ClusterStatePersistor clusterStatePersistor) {
        this.consoleLogger = consoleLogger;
        this.groupManager = groupManager;
        this.stateChangeSink = stateChangeSink;
        this.weightsFactory = weightFactory;
        this.electionMgr = new ElectionManagerImpl(groupManager, expectedServers, electionTimeInSec);
        this.electionSink = mgr.createStage("l2_election_handler_stage", ElectionContext.class, this.electionMgr.getEventHandler(), 1, 1024).getSink();
        this.clusterStatePersistor = clusterStatePersistor;
    }

    @Override
    public State getCurrentState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean electionStarted() {
        boolean isElectionStarted = this.elections.electionStarted();
        if (isElectionStarted) {
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                this.prevKnownServers.clear();
                this.prevKnownServers.addAll(this.currKnownServers);
                this.currKnownServers.clear();
            }
        }
        return isElectionStarted;
    }

    private boolean electionFinished() {
        return this.elections.electionFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeclaredActive() throws InterruptedException {
        StateManagerImpl stateManagerImpl = this;
        synchronized (stateManagerImpl) {
            while (this.activeNode.isNull()) {
                this.wait();
            }
        }
        this.elections.waitForElectionToFinish();
    }

    public void endElection() {
        this.initiated = false;
        this.state = STOP_STATE;
        this.activeNode = ServerID.NULL_ID;
    }

    @Override
    public void startElection() {
        StateManagerImpl.debugInfo("Starting election");
        this.initiated = true;
        this.startState = this.clusterStatePersistor.getInitialState();
        this.info("Starting election initial state:" + this.startState);
        if (this.startState != null && !this.startState.equals((Object)ACTIVE_COORDINATOR)) {
            this.info("Skipping election and waiting for the active to zap since this L2 did not go down as active.");
        } else if (this.state == START_STATE || this.state == PASSIVE_STANDBY) {
            this.runElection();
        } else {
            this.info("Ignoring Election request since not in right state");
        }
    }

    private void runElection() {
        boolean isNew;
        if (!this.electionStarted()) {
            return;
        }
        NodeID myNodeID = this.getLocalNodeID();
        boolean bl = isNew = this.state == START_STATE && this.startState == null;
        if (this.getActiveNodeID().isNull()) {
            StateManagerImpl.debugInfo("Running election - isNew: " + isNew);
            this.electionSink.addSingleThreaded((Object)new ElectionContext(myNodeID, isNew, this.weightsFactory, this.state, nodeid -> {
                boolean rerun = false;
                if (nodeid == myNodeID) {
                    StateManagerImpl.debugInfo("Won Election, moving to active state. myNodeID/winner=" + myNodeID);
                    this.moveToActiveState();
                } else if (nodeid.isNull()) {
                    Assert.fail();
                } else {
                    this.electionMgr.reset(null);
                    StateManagerImpl.debugInfo("Lost election, waiting for winner to declare as active, winner=" + nodeid);
                    if (!this.waitUntilActiveNodeIDNotNull(this.electionMgr.getElectionTime())) {
                        logger.info((Object)("rerunning election because " + nodeid + " never declared active"));
                        rerun = true;
                    }
                }
                this.electionFinished();
                if (rerun) {
                    this.runElection();
                }
            }));
        } else {
            this.electionFinished();
        }
    }

    private synchronized boolean waitUntilActiveNodeIDNotNull(long timeout) {
        while (this.activeNode.isNull() && timeout > 0L) {
            long start = System.currentTimeMillis();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Interrupted while waiting for ACTIVE to declare WON message ! ", (Throwable)e);
                break;
            }
            timeout -= System.currentTimeMillis() - start;
        }
        StateManagerImpl.debugInfo("Wait for other active to declare as active over. Declared? activeNodeId.isNull() = " + this.activeNode.isNull() + ", activeNode=" + this.activeNode);
        return !this.activeNode.isNull();
    }

    private void setActiveNodeID(NodeID nodeID) {
        StateManagerImpl.debugInfo("SETTING activeNode=" + nodeID);
        this.activeNode = nodeID;
        this.notifyAll();
    }

    private NodeID getLocalNodeID() {
        return this.groupManager.getLocalNodeID();
    }

    @Override
    public void registerForStateChangeEvents(StateChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void fireStateChangedEvent(StateChangedEvent sce) {
        for (StateChangeListener listener : this.listeners) {
            listener.l2StateChanged(sce);
        }
    }

    private synchronized void moveToPassiveReady(Enrollment winningEnrollment) {
        this.electionMgr.reset(winningEnrollment);
        logger.info((Object)("moving to passive ready " + this.state + " " + winningEnrollment));
        if (this.state == START_STATE) {
            this.setActiveNodeID(winningEnrollment.getNodeID());
            State state = this.state = this.startState == null ? PASSIVE_UNINITIALIZED : this.startState;
            if (!this.state.equals((Object)PASSIVE_STANDBY) && !this.state.equals((Object)PASSIVE_UNINITIALIZED)) {
                logger.fatal((Object)("caught in an unclean state " + this.state));
                this.clusterStatePersistor.setDBClean(false);
                throw new TCServerRestartException("Caught in an inconsistent state.  Restarting with a new DB");
            }
            this.info("Moved to " + this.state, true);
            this.fireStateChangedOperatorEvent();
            this.stateChangeSink.addSingleThreaded((Object)new StateChangedEvent(START_STATE, this.state));
        } else if (this.state == PASSIVE_UNINITIALIZED) {
            Assert.assertTrue((boolean)this.syncdTo.isNull());
            this.setActiveNodeID(winningEnrollment.getNodeID());
        } else if (this.state == PASSIVE_SYNCING) {
            this.setActiveNodeID(winningEnrollment.getNodeID());
            if (!this.syncdTo.equals(winningEnrollment.getNodeID())) {
                logger.fatal((Object)"Passive only partially synced when active disappeared.  Restarting");
                this.clusterStatePersistor.setDBClean(false);
                throw new TCServerRestartException("Passive only partially synced when active disappeared.  Restarting");
            }
        } else {
            if (this.state == ACTIVE_COORDINATOR) {
                throw new AssertionError((Object)("Cant move to " + PASSIVE_UNINITIALIZED + " from " + ACTIVE_COORDINATOR + " at least for now"));
            }
            this.setActiveNodeID(winningEnrollment.getNodeID());
        }
    }

    @Override
    public synchronized void moveToPassiveSyncing(NodeID connectedTo) {
        if (this.state == PASSIVE_UNINITIALIZED) {
            this.syncdTo = connectedTo;
            this.stateChangeSink.addSingleThreaded((Object)new StateChangedEvent(this.state, PASSIVE_SYNCING));
            this.state = PASSIVE_SYNCING;
            this.info("Moved to " + this.state, true);
            this.fireStateChangedOperatorEvent();
        }
    }

    @Override
    public synchronized void moveToPassiveStandbyState() {
        if (this.state == ACTIVE_COORDINATOR) {
            throw new AssertionError((Object)("Cant move to " + PASSIVE_STANDBY + " from " + ACTIVE_COORDINATOR + " at least for now"));
        }
        if (this.state != PASSIVE_STANDBY) {
            this.stateChangeSink.addSingleThreaded((Object)new StateChangedEvent(this.state, PASSIVE_STANDBY));
            this.state = PASSIVE_STANDBY;
            this.info("Moved to " + this.state, true);
            this.fireStateChangedOperatorEvent();
        } else {
            this.info("Already in " + this.state);
        }
    }

    private synchronized void moveToActiveState() {
        if (this.state != START_STATE && this.state != PASSIVE_STANDBY) {
            throw new AssertionError((Object)("Cant move to " + ACTIVE_COORDINATOR + " from " + this.state));
        }
        StateManagerImpl.debugInfo("Moving to active state");
        StateChangedEvent event = new StateChangedEvent(this.state, ACTIVE_COORDINATOR);
        this.state = ACTIVE_COORDINATOR;
        this.stateChangeSink.addSingleThreaded((Object)event);
        this.setActiveNodeID(this.getLocalNodeID());
        this.info("Becoming " + this.state, true);
        this.fireStateChangedOperatorEvent();
        this.currKnownServers.clear();
        this.currKnownServers.addAll(this.prevKnownServers);
        this.electionMgr.declareWinner(this.getLocalNodeID(), this.state);
    }

    @Override
    public synchronized NodeID getActiveNodeID() {
        return this.activeNode;
    }

    @Override
    public synchronized void cleanupKnownServers() {
        this.currKnownServers.removeIf(node -> !this.groupManager.isNodeConnected((NodeID)node));
    }

    @Override
    public boolean isActiveCoordinator() {
        return this.state == ACTIVE_COORDINATOR;
    }

    public boolean isPassiveUnitialized() {
        return this.state == PASSIVE_UNINITIALIZED;
    }

    @Override
    public void handleClusterStateMessage(L2StateMessage clusterMsg) {
        StateManagerImpl.debugInfo("Received cluster state message: " + clusterMsg);
        try {
            switch (clusterMsg.getType()) {
                case 0: {
                    this.handleStartElectionRequest(clusterMsg);
                    break;
                }
                case 4: {
                    this.handleElectionAbort(clusterMsg);
                    break;
                }
                case 1: {
                    this.handleElectionResultMessage(clusterMsg);
                    break;
                }
                case 5: 
                case 6: {
                    this.handleElectionWonMessage(clusterMsg);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("This message shouldn't have been routed here : " + clusterMsg));
                }
            }
        }
        catch (GroupException ge) {
            logger.error((Object)("Zapping Node : Caught Exception while handling Message : " + clusterMsg), (Throwable)ge);
            this.groupManager.zapNode(clusterMsg.messageFrom(), 1, "Error handling Election Message " + L2HAZapNodeRequestProcessor.getErrorString(ge));
        }
    }

    private synchronized void handleElectionWonMessage(L2StateMessage clusterMsg) {
        StateManagerImpl.debugInfo("Received election_won or election_already_won msg: " + clusterMsg);
        Enrollment winningEnrollment = clusterMsg.getEnrollment();
        if (this.state == ACTIVE_COORDINATOR) {
            String error = this.state + " Received Election Won Msg : " + clusterMsg + ". A Terracotta server tried to join the mirror group as a second ACTIVE";
            logger.error((Object)error);
            if (clusterMsg.getType() == 6) {
                this.sendNGResponse(clusterMsg.messageFrom(), clusterMsg);
            }
            this.groupManager.zapNode(winningEnrollment.getNodeID(), 255, error);
        } else if (this.activeNode.isNull() || this.activeNode.equals(winningEnrollment.getNodeID()) || clusterMsg.getType() == 5) {
            if (this.startState == null || this.startState == START_STATE) {
                this.moveToPassiveReady(winningEnrollment);
                if (clusterMsg.getType() == 6) {
                    this.sendOKResponse(clusterMsg.messageFrom(), clusterMsg);
                }
            } else if (clusterMsg.getType() == 6) {
                this.sendNGResponse(clusterMsg.messageFrom(), clusterMsg);
            }
        } else {
            logger.warn((Object)("Conflicting Election Won  Msg : " + clusterMsg + " since I already have a ACTIVE Node : " + this.activeNode + ". Sending NG response"));
            this.sendNGResponse(clusterMsg.messageFrom(), clusterMsg);
        }
    }

    private synchronized void handleElectionResultMessage(L2StateMessage msg) throws GroupException {
        if (this.activeNode.equals(msg.getEnrollment().getNodeID())) {
            Assert.assertFalse((boolean)ServerID.NULL_ID.equals((Object)this.activeNode));
            L2StateMessage resultAgreed = L2StateMessage.createResultAgreedMessage((L2StateMessage)msg, (Enrollment)msg.getEnrollment(), (State)this.state);
            logger.info((Object)("Agreed with Election Result from " + msg.messageFrom() + " : " + resultAgreed));
            this.groupManager.sendTo(msg.messageFrom(), (AbstractGroupMessage)resultAgreed);
        } else if (this.state == ACTIVE_COORDINATOR || !this.activeNode.isNull() || msg.getEnrollment().isANewCandidate() && this.state != START_STATE) {
            L2StateMessage resultConflict = L2StateMessage.createResultConflictMessage((L2StateMessage)msg, (Enrollment)EnrollmentFactory.createTrumpEnrollment(this.getLocalNodeID(), this.weightsFactory), (State)this.state);
            this.warn("WARNING :: Active Node = " + this.activeNode + " , " + this.state + " received ELECTION_RESULT message from another node : " + msg + " : Forcing re-election " + resultConflict);
            this.groupManager.sendTo(msg.messageFrom(), (AbstractGroupMessage)resultConflict);
        } else {
            StateManagerImpl.debugInfo("ElectionMgr handling election result msg: " + msg);
            this.electionMgr.handleElectionResultMessage(msg, this.state);
        }
    }

    private synchronized void handleElectionAbort(L2StateMessage clusterMsg) {
        if (this.state == ACTIVE_COORDINATOR) {
            String error = this.state + " Received Abort Election  Msg : Possible split brain detected ";
            logger.error((Object)error);
            this.groupManager.zapNode(clusterMsg.messageFrom(), 255, error);
        } else {
            StateManagerImpl.debugInfo("ElectionMgr handling election abort");
            this.electionMgr.handleElectionAbort(clusterMsg, this.state);
            this.moveToPassiveReady(clusterMsg.getEnrollment());
        }
    }

    private synchronized void handleStartElectionRequest(L2StateMessage msg) throws GroupException {
        if (this.state == ACTIVE_COORDINATOR) {
            L2StateMessage abortMsg = L2StateMessage.createAbortElectionMessage((L2StateMessage)msg, (Enrollment)EnrollmentFactory.createTrumpEnrollment(this.getLocalNodeID(), this.weightsFactory), (State)this.state);
            this.info("Forcing Abort Election for " + msg + " with " + abortMsg);
            this.groupManager.sendTo(msg.messageFrom(), (AbstractGroupMessage)abortMsg);
        } else {
            this.currKnownServers.add(msg.getEnrollment().getNodeID());
            if (!this.electionMgr.handleStartElectionRequest(msg, this.state)) {
                this.startElectionIfNecessary((NodeID)ServerID.NULL_ID);
            }
        }
    }

    @Override
    public void publishActiveState(NodeID nodeID) throws GroupException {
        StateManagerImpl.debugInfo("Publishing active state to nodeId: " + nodeID);
        Assert.assertTrue((boolean)this.isActiveCoordinator());
        L2StateMessage msg = L2StateMessage.createElectionWonAlreadyMessage((Enrollment)EnrollmentFactory.createTrumpEnrollment(this.getLocalNodeID(), this.weightsFactory), (State)this.state);
        L2StateMessage response = (L2StateMessage)this.groupManager.sendToAndWaitForResponse(nodeID, (AbstractGroupMessage)msg);
        this.validateResponse(nodeID, response);
    }

    public synchronized void addKnownServersList(Set<NodeID> nodeIDs) {
        this.currKnownServers.addAll(nodeIDs);
    }

    private void validateResponse(NodeID nodeID, L2StateMessage response) throws GroupException {
        if (response == null || response.getType() != 2) {
            String error = "Recd wrong response from : " + nodeID + " : msg = " + response + " while publishing Active State";
            logger.error((Object)error);
            throw new GroupException(error);
        }
        if (response.getState().equals((Object)PASSIVE_STANDBY) && !this.currKnownServers.contains(nodeID)) {
            String errMesg = "A Terracotta server tried to join the mirror group as PASSIVE STANDBY but with dirty db,  Zapping " + nodeID + " to allow it to resync data from active";
            logger.error((Object)errMesg);
            this.groupManager.zapNode(nodeID, 3, errMesg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElectionIfNecessary(NodeID disconnectedNode) {
        Assert.assertFalse((boolean)disconnectedNode.equals(this.getLocalNodeID()));
        boolean elect = false;
        StateManagerImpl stateManagerImpl = this;
        synchronized (stateManagerImpl) {
            this.currKnownServers.remove(disconnectedNode);
            if (!this.initiated) {
                return;
            }
            if (this.state == START_STATE || !disconnectedNode.isNull() && disconnectedNode.equals(this.activeNode)) {
                this.setActiveNodeID((NodeID)ServerID.NULL_ID);
            }
            if (this.state == PASSIVE_SYNCING && this.syncdTo.equals(disconnectedNode)) {
                logger.fatal((Object)"Passive only partially synced when active disappeared.  Restarting");
                this.clusterStatePersistor.setDBClean(false);
                throw new TCServerRestartException("Passive only partially synced when active disappeared.  Restarting");
            }
            if (this.state != ACTIVE_COORDINATOR && this.activeNode.isNull()) {
                elect = true;
            }
        }
        if (elect) {
            this.info("Starting Election to determine cluster wide ACTIVE L2");
            this.runElection();
        } else {
            StateManagerImpl.debugInfo("Not starting election even though node left: " + disconnectedNode);
        }
    }

    private void sendOKResponse(NodeID fromNode, L2StateMessage msg) {
        try {
            this.groupManager.sendTo(fromNode, (AbstractGroupMessage)L2StateMessage.createResultAgreedMessage((L2StateMessage)msg, (Enrollment)msg.getEnrollment(), (State)this.state));
        }
        catch (GroupException e) {
            logger.error((Object)("Error handling message : " + msg), (Throwable)e);
        }
    }

    private void sendNGResponse(NodeID fromNode, L2StateMessage msg) {
        try {
            this.groupManager.sendTo(fromNode, (AbstractGroupMessage)L2StateMessage.createResultConflictMessage((L2StateMessage)msg, (Enrollment)msg.getEnrollment(), (State)this.state));
        }
        catch (GroupException e) {
            logger.error((Object)("Error handling message : " + msg), (Throwable)e);
        }
    }

    public String toString() {
        return StateManagerImpl.class.getSimpleName() + ":" + this.state.toString();
    }

    private void fireStateChangedOperatorEvent() {
        TSAManagementEventPayload tsaManagementEventPayload = new TSAManagementEventPayload("TSA.L2.STATE_CHANGE");
        tsaManagementEventPayload.getAttributes().put("State", this.state.getName());
        TerracottaRemoteManagement.getRemoteManagementInstance().sendEvent(tsaManagementEventPayload.toManagementEvent());
        this.operatorEventLogger.fireOperatorEvent(TerracottaOperatorEventFactory.createClusterNodeStateChangedEvent((String)this.state.getName()));
    }

    private void info(String message) {
        this.info(message, false);
    }

    private void info(String message, boolean console) {
        logger.info((Object)message);
        if (console) {
            this.consoleLogger.info((Object)message);
        }
    }

    private void warn(String message) {
        this.warn(message, false);
    }

    private void warn(String message, boolean console) {
        logger.warn((Object)message);
        if (console) {
            this.consoleLogger.warn((Object)message);
        }
    }

    private static void debugInfo(String message) {
        logger.debug((Object)message);
    }

    private static class ElectionGate {
        private boolean electionInProgress = false;

        private ElectionGate() {
        }

        public synchronized boolean electionStarted() {
            try {
                boolean bl = !this.electionInProgress;
                return bl;
            }
            finally {
                this.electionInProgress = true;
                this.notifyAll();
            }
        }

        public synchronized boolean electionFinished() {
            try {
                boolean bl = this.electionInProgress;
                return bl;
            }
            finally {
                this.electionInProgress = false;
                this.notifyAll();
            }
        }

        public synchronized boolean isFinished() {
            return this.electionInProgress;
        }

        public synchronized void waitForElectionToFinish() throws InterruptedException {
            while (this.electionInProgress) {
                this.wait();
            }
        }
    }
}

