/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management;

import com.tc.management.ManagementEventListener;
import com.tc.management.ManagementResponseListener;
import com.tc.management.RemoteManagement;
import com.tc.management.RemoteManagementException;
import com.tc.management.TCManagementEvent;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.management.ManagementRequestID;
import com.tc.object.management.RemoteCallDescriptor;
import com.tc.object.management.RemoteCallHolder;
import com.tc.object.management.ResponseHolder;
import com.tc.object.management.TCManagementSerializationException;
import com.tc.object.msg.AbstractManagementMessage;
import com.tc.object.msg.InvokeRegisteredServiceMessage;
import com.tc.object.msg.InvokeRegisteredServiceResponseMessage;
import com.tc.object.msg.ListRegisteredServicesMessage;
import com.tc.object.msg.ListRegisteredServicesResponseMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.NoSuchChannelException;
import com.tc.objectserver.handler.ServerManagementHandler;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteManagementImpl
implements RemoteManagement {
    private final DSOChannelManager channelManager;
    private final ServerManagementHandler serverManagementHandler;
    private final String thisServerNodeName;

    public RemoteManagementImpl(DSOChannelManager channelManager, ServerManagementHandler serverManagementHandler, String thisServerNodeName) {
        this.channelManager = channelManager;
        this.serverManagementHandler = serverManagementHandler;
        this.thisServerNodeName = thisServerNodeName;
    }

    public void sendEvent(TCManagementEvent event) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("CONTEXT_SOURCE_NODE_NAME", this.thisServerNodeName);
        this.serverManagementHandler.fireEvent(event, context);
    }

    public void registerEventListener(ManagementEventListener listener) {
        this.serverManagementHandler.registerEventListener(listener);
    }

    public void unregisterEventListener(ManagementEventListener listener) {
        this.serverManagementHandler.unregisterEventListener(listener);
    }

    public Set<NodeID> getAllClientIDs() {
        return this.channelManager.getAllClientIDs();
    }

    public Set<RemoteCallDescriptor> listRegisteredServices(NodeID node, long timeout, TimeUnit unit) throws RemoteManagementException {
        ListRegisteredServicesMessage message;
        try {
            message = (ListRegisteredServicesMessage)this.channelManager.getActiveChannel(node).createMessage(TCMessageType.LIST_REGISTERED_SERVICES_MESSAGE);
        }
        catch (NoSuchChannelException nsce) {
            throw new RemoteManagementException("Error listing registered management services", nsce);
        }
        final AtomicReference remoteCallDescriptors = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.serverManagementHandler.registerResponseListener(message.getManagementRequestID(), new ManagementResponseListener(){

            @Override
            public void onResponse(AbstractManagementMessage mgmtMessage) {
                ListRegisteredServicesResponseMessage response = (ListRegisteredServicesResponseMessage)mgmtMessage;
                remoteCallDescriptors.set(response.getRemoteCallDescriptors());
                RemoteManagementImpl.this.serverManagementHandler.unregisterResponseListener(mgmtMessage.getManagementRequestID());
                latch.countDown();
            }
        });
        message.send();
        try {
            if (!latch.await(timeout, unit)) {
                this.serverManagementHandler.unregisterResponseListener(message.getManagementRequestID());
                throw new RemoteManagementException("Timed out while waiting for listRegisteredServices() response");
            }
        }
        catch (InterruptedException ie) {
            this.serverManagementHandler.unregisterResponseListener(message.getManagementRequestID());
            throw new RemoteManagementException("Interrupted while waiting for listRegisteredServices() response", ie);
        }
        return (Set)remoteCallDescriptors.get();
    }

    public Future<Object> asyncRemoteCall(final RemoteCallDescriptor remoteCallDescriptor, final ClassLoader classLoader, Object ... args) throws RemoteManagementException {
        InvokeRegisteredServiceMessage invokeMessage;
        try {
            invokeMessage = (InvokeRegisteredServiceMessage)this.channelManager.getActiveChannel(remoteCallDescriptor.getL1Node()).createMessage(TCMessageType.INVOKE_REGISTERED_SERVICE_MESSAGE);
        }
        catch (NoSuchChannelException nsce) {
            throw new RemoteManagementException("Error calling management services", nsce);
        }
        final AtomicReference exception = new AtomicReference();
        final AtomicReference response = new AtomicReference();
        RemoteCallHolder remoteCallHolder = new RemoteCallHolder(remoteCallDescriptor, args);
        invokeMessage.setRemoteCallHolder(remoteCallHolder);
        final AtomicReference responseManagementRequestIDRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.serverManagementHandler.registerResponseListener(invokeMessage.getManagementRequestID(), new ManagementResponseListener(){

            @Override
            public void onResponse(AbstractManagementMessage message) {
                InvokeRegisteredServiceResponseMessage responseMessage = (InvokeRegisteredServiceResponseMessage)message;
                ResponseHolder responseHolder = responseMessage.getResponseHolder();
                try {
                    exception.set(responseHolder.getException(classLoader));
                    response.set(responseHolder.getResponse(classLoader));
                }
                catch (ClassNotFoundException cnfe) {
                    exception.set(new TCManagementSerializationException("Error deserializing management response", (Throwable)cnfe));
                    response.set(null);
                }
                ManagementRequestID managementRequestID = message.getManagementRequestID();
                responseManagementRequestIDRef.set(managementRequestID);
                RemoteManagementImpl.this.serverManagementHandler.unregisterResponseListener(managementRequestID);
                latch.countDown();
            }
        });
        final ManagementRequestID sentManagementRequestID = invokeMessage.getManagementRequestID();
        invokeMessage.send();
        return new Future<Object>(){
            private volatile boolean cancelled = false;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.cancelled) {
                    return true;
                }
                if (!this.isDone()) {
                    this.cancelled = true;
                    RemoteManagementImpl.this.serverManagementHandler.unregisterResponseListener(sentManagementRequestID);
                    latch.countDown();
                    return true;
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled;
            }

            @Override
            public boolean isDone() {
                return latch.getCount() == 0L;
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                latch.await();
                if (this.isCancelled()) {
                    throw new CancellationException("Management remote L1 call on " + remoteCallDescriptor.getL1Node() + " got cancelled");
                }
                if (exception.get() != null) {
                    throw new ExecutionException(new RemoteManagementException("Error performing management remote L1 call on " + remoteCallDescriptor.getL1Node(), (Throwable)exception.get()));
                }
                return response.get();
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (!latch.await(timeout, unit)) {
                    throw new TimeoutException("Timed out waiting for management remote L1 call response");
                }
                if (this.isCancelled()) {
                    throw new CancellationException("Management remote L1 call on " + remoteCallDescriptor.getL1Node() + " got cancelled");
                }
                if (exception.get() != null) {
                    throw new ExecutionException(new RemoteManagementException("Error performing management remote L1 call on " + remoteCallDescriptor.getL1Node(), (Throwable)exception.get()));
                }
                return response.get();
            }
        };
    }
}

