/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.beans;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.TerracottaManagement;
import com.tc.management.beans.L2DumperMBean;
import com.tc.management.beans.TCDumper;
import java.lang.reflect.Method;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class L2Dumper
extends AbstractTerracottaMBean
implements L2DumperMBean {
    private static final TCLogger logger = TCLogging.getLogger(L2Dumper.class);
    private static final boolean DEBUG = false;
    private static final String THREAD_DUMP_METHOD_NAME = "dumpThreadsMany";
    private static final Class<?>[] THREAD_DUMP_METHOD_PARAMETERS = new Class[]{Integer.TYPE, Long.TYPE};
    private static final int DEFAULT_THREAD_DUMP_COUNT = 3;
    private static final long DEFAULT_THREAD_DUMP_INTERVAL = 1000L;
    private int threadDumpCount = 3;
    private long threadDumpInterval = 1000L;
    private final TCDumper dumper;
    private final MBeanServer mbs;

    public L2Dumper(TCDumper dumper, MBeanServer mbs) throws NotCompliantMBeanException {
        super(L2DumperMBean.class, false);
        this.dumper = dumper;
        this.mbs = mbs;
    }

    @Override
    public void doServerDump() {
        logger.info((Object)"Server dump: ");
        this.dumper.dump();
    }

    @Override
    public void setThreadDumpCount(int count) {
        this.threadDumpCount = count;
    }

    @Override
    public void setThreadDumpInterval(long interval) {
        this.threadDumpInterval = interval;
    }

    @Override
    public int doThreadDump() throws Exception {
        this.debugPrintln("ThreadDumping:  count=[" + this.threadDumpCount + "] interval=[" + this.threadDumpInterval + "]");
        Class<?> threadDumpClass = this.getClass().getClassLoader().loadClass("com.tc.util.runtime.ThreadDump");
        Method method = threadDumpClass.getMethod(THREAD_DUMP_METHOD_NAME, THREAD_DUMP_METHOD_PARAMETERS);
        Object[] args = new Object[]{this.threadDumpCount, this.threadDumpInterval};
        int pid = (Integer)method.invoke(null, args);
        return pid;
    }

    public void reset() {
    }

    private void debugPrintln(String s) {
    }

    @Override
    public void dumpClusterState() {
        Set allL1DumperMBeans;
        Set allL2DumperMBeans;
        try {
            allL2DumperMBeans = TerracottaManagement.getAllL2DumperMBeans((MBeanServerConnection)this.mbs);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        for (ObjectName l2DumperBean : allL2DumperMBeans) {
            try {
                this.mbs.invoke(l2DumperBean, "doServerDump", new Object[0], new String[0]);
            }
            catch (Exception e) {
                logger.error((Object)("error dumping on " + l2DumperBean), (Throwable)e);
            }
        }
        try {
            allL1DumperMBeans = TerracottaManagement.getAllL1DumperMBeans((MBeanServerConnection)this.mbs);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        for (ObjectName l1DumperBean : allL1DumperMBeans) {
            try {
                this.mbs.invoke(l1DumperBean, "doClientDump", new Object[0], new String[0]);
            }
            catch (Exception e) {
                logger.error((Object)("error dumping on " + l1DumperBean), (Throwable)e);
            }
        }
    }
}

