/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.beans;

import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.state.StateChangeListener;
import com.tc.l2.state.StateManager;
import com.tc.util.State;

public class L2State
implements StateChangeListener {
    private static final boolean DEBUG = false;
    private State serverState = StateManager.START_STATE;
    private StateChangeListener changeListener;

    public synchronized void setState(State state) {
        if (!this.validateState(state)) {
            throw new AssertionError((Object)("Unrecognized server state: [" + state.getName() + "]"));
        }
        if (this.changeListener != null) {
            this.debugPrintln("*******  L2State is notifying listener of state change:  oldState=[" + this.serverState.getName() + "] newState=[" + state.getName() + "]");
            this.changeListener.l2StateChanged(new StateChangedEvent(this.serverState, state));
        }
        this.serverState = state;
    }

    private void debugPrintln(String s) {
    }

    public synchronized State getState() {
        return this.serverState;
    }

    private boolean validateState(State state) {
        return StateManager.VALID_STATES.contains(state);
    }

    @Override
    public void l2StateChanged(StateChangedEvent sce) {
        this.setState(sce.getCurrentState());
    }

    public boolean isActiveCoordinator() {
        return this.getState().equals((Object)StateManager.ACTIVE_COORDINATOR);
    }

    public boolean isPassiveUninitialized() {
        return this.getState().equals((Object)StateManager.PASSIVE_UNINITIALIZED);
    }

    public boolean isPassiveStandby() {
        return this.getState().equals((Object)StateManager.PASSIVE_STANDBY);
    }

    public boolean isStartState() {
        return this.getState().equals((Object)StateManager.START_STATE);
    }

    public boolean isStopState() {
        return this.getState().equals((Object)StateManager.STOP_STATE);
    }

    public boolean isRecovering() {
        return this.getState().equals((Object)StateManager.RECOVERING);
    }

    public void registerStateChangeListener(StateChangeListener listener) {
        if (this.changeListener != null) {
            throw new AssertionError((Object)"State change listerer is already set.");
        }
        this.changeListener = listener;
    }

    public String toString() {
        return this.getState().getName();
    }
}

