/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.l2.L2DebugLogging;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.groups.Node;
import com.tc.net.protocol.tcm.ChannelEvent;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ChannelEventType;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;

public class DiscoveryStateMachine
implements ChannelEventListener {
    private static final TCLogger logger = TCLogging.getLogger(DiscoveryStateMachine.class);
    private static final long DISCOVERY_INTERVAL_MS = TCPropertiesImpl.getProperties().getLong("l2.nha.tcgroupcomm.discovery.interval");
    private final DiscoveryState STATE_INIT = new InitState();
    private final DiscoveryState STATE_CONNECTING = new ConnectingState();
    private final DiscoveryState STATE_CONNECTED = new ConnectedState();
    private final DiscoveryState STATE_CONNECT_TIMEOUT = new ConnectTimeoutState();
    private final DiscoveryState STATE_MAX_CONNECTION = new MaxConnExceedState();
    private final DiscoveryState STATE_STACK_MISMATCH = new CommStackMismatchState();
    private final DiscoveryState STATE_IO_EXCEPTION = new IOExceptionState();
    private final DiscoveryState STATE_THROWABLE_EXCEP = new ThrowableExceptionState();
    private final DiscoveryState STATE_UNKNOWN_HOST = new UnknownHostState();
    private final DiscoveryState STATE_MEMBER_IN_GROUP = new MemberInGroupState();
    private DiscoveryState current;
    private DiscoveryState previousBadState;
    private final Node node;
    private int badCount;
    private long timestamp;
    private long previousLogTimeStamp;
    private MessageChannel connectedChannel;

    public DiscoveryStateMachine(Node node) {
        this.node = node;
    }

    public void loggerWarn(String message) {
        if (System.currentTimeMillis() > this.previousLogTimeStamp + 60000L) {
            logger.warn((Object)message);
            this.previousLogTimeStamp = System.currentTimeMillis();
        }
    }

    public final void start() {
        this.switchToState(this.initialState());
    }

    protected DiscoveryState initialState() {
        return this.STATE_INIT;
    }

    protected synchronized void switchToState(DiscoveryState state) {
        Assert.assertNotNull((Object)state);
        DiscoveryStateMachine.debugInfo("DiscoverStateMachine [" + this.node + "]: switching to state: " + state);
        this.current = state;
        state.enter();
    }

    protected synchronized boolean switchToStateFrom(DiscoveryState from, DiscoveryState to) {
        Assert.assertNotNull((Object)from);
        Assert.assertNotNull((Object)to);
        if (this.current == from) {
            this.current = to;
            to.enter();
            return true;
        }
        logger.warn((Object)("DiscoverStateMachine [" + this.node + "]: Ignored switching state from: " + from + ", to: " + to + ", current: " + this.current));
        return false;
    }

    Node getNode() {
        return this.node;
    }

    synchronized boolean isMemberInGroup() {
        return this.current == this.STATE_MEMBER_IN_GROUP;
    }

    synchronized boolean isTimeToConnect() {
        return this.current.isTimeToConnect();
    }

    void connecting() {
        Assert.eval((this.current != this.STATE_CONNECTING ? 1 : 0) != 0);
        this.switchToState(this.STATE_CONNECTING);
    }

    void connected() {
        this.switchToStateFrom(this.STATE_CONNECTING, this.STATE_CONNECTED);
    }

    private void notifyDisconnected() {
        if (!this.switchToStateFrom(this.STATE_CONNECTING, this.STATE_INIT)) {
            this.switchToStateFrom(this.STATE_CONNECTED, this.STATE_INIT);
        }
    }

    synchronized void badConnect(DiscoveryState state) {
        if (this.current == this.STATE_MEMBER_IN_GROUP) {
            return;
        }
        this.switchToState(state);
    }

    void connectTimeout() {
        this.badConnect(this.STATE_CONNECT_TIMEOUT);
    }

    void maxConnExceed() {
        this.badConnect(this.STATE_MAX_CONNECTION);
    }

    void commStackMismatch() {
        this.badConnect(this.STATE_STACK_MISMATCH);
    }

    void connetIOException() {
        this.badConnect(this.STATE_IO_EXCEPTION);
    }

    void throwableException() {
        this.badConnect(this.STATE_THROWABLE_EXCEP);
    }

    synchronized void unknownHost() {
        if (this.current == this.STATE_UNKNOWN_HOST) {
            return;
        }
        if (this.current == this.STATE_MEMBER_IN_GROUP) {
            return;
        }
        this.switchToState(this.STATE_UNKNOWN_HOST);
    }

    synchronized void nodeJoined() {
        this.switchToState(this.STATE_MEMBER_IN_GROUP);
    }

    synchronized void nodeLeft() {
        this.switchToState(this.STATE_INIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChannelEvent(ChannelEvent event) {
        if (event.getType() == ChannelEventType.TRANSPORT_CONNECTED_EVENT || event.getType() == ChannelEventType.CHANNEL_OPENED_EVENT) {
            DiscoveryStateMachine discoveryStateMachine = this;
            synchronized (discoveryStateMachine) {
                this.connectedChannel = event.getChannel();
            }
        }
        if (event.getType() == ChannelEventType.TRANSPORT_DISCONNECTED_EVENT || event.getType() == ChannelEventType.CHANNEL_CLOSED_EVENT) {
            DiscoveryStateMachine discoveryStateMachine = this;
            synchronized (discoveryStateMachine) {
                if (this.canNotifyDisconnect(event)) {
                    this.notifyDisconnected();
                    this.connectedChannel = null;
                }
            }
        }
    }

    private synchronized boolean canNotifyDisconnect(ChannelEvent event) {
        MessageChannel eventChannel = event.getChannel();
        boolean rv = this.connectedChannel == null ? false : this.connectedChannel == eventChannel && this.connectedChannel.getLocalAddress() == eventChannel.getLocalAddress() && this.connectedChannel.getRemoteAddress() == eventChannel.getRemoteAddress();
        return rv;
    }

    private static void debugInfo(String message) {
        L2DebugLogging.log(logger, L2DebugLogging.LogLevel.INFO, message, null);
    }

    private class MemberInGroupState
    extends DiscoveryState {
        public MemberInGroupState() {
            super("Member-In-Group");
        }

        @Override
        public boolean isTimeToConnect() {
            return false;
        }
    }

    private class UnknownHostState
    extends DiscoveryState {
        public UnknownHostState() {
            super("Unknown-Host");
        }

        @Override
        public void enter() {
            if (DiscoveryStateMachine.this.previousBadState == null || DiscoveryStateMachine.this.previousBadState != DiscoveryStateMachine.this.current) {
                super.enter();
                DiscoveryStateMachine.this.timestamp = System.currentTimeMillis();
            }
        }

        @Override
        public boolean isTimeToConnect() {
            if (System.currentTimeMillis() > DiscoveryStateMachine.this.timestamp + 300000L) {
                DiscoveryStateMachine.this.timestamp = System.currentTimeMillis();
                return true;
            }
            return false;
        }
    }

    private class ThrowableExceptionState
    extends BadState {
        public ThrowableExceptionState() {
            super("Connection-Throwable");
        }
    }

    private class IOExceptionState
    extends BadState {
        public IOExceptionState() {
            super("IO-Exception");
        }
    }

    private class CommStackMismatchState
    extends VeryBadState {
        public CommStackMismatchState() {
            super("Comm-Stack-Mismatch");
        }
    }

    private class MaxConnExceedState
    extends BadState {
        public MaxConnExceedState() {
            super("Max-Connections-Exceed");
        }
    }

    private class ConnectTimeoutState
    extends BadState {
        public ConnectTimeoutState() {
            super("Connection-Timeouted");
        }
    }

    private abstract class VeryBadState
    extends DiscoveryState {
        public VeryBadState(String name) {
            super(name);
        }

        @Override
        public boolean isTimeToConnect() {
            return false;
        }
    }

    private abstract class BadState
    extends DiscoveryState {
        public BadState(String name) {
            super(name);
        }

        @Override
        public void enter() {
            if (DiscoveryStateMachine.this.previousBadState == null || DiscoveryStateMachine.this.previousBadState != DiscoveryStateMachine.this.current) {
                DiscoveryStateMachine.this.badCount = 0;
                DiscoveryStateMachine.this.previousBadState = DiscoveryStateMachine.this.current;
                DiscoveryStateMachine.this.previousLogTimeStamp = 0L;
            } else {
                ++DiscoveryStateMachine.this.badCount;
            }
        }

        @Override
        public boolean isTimeToConnect() {
            if (DiscoveryStateMachine.this.badCount < 60) {
                return true;
            }
            if (System.currentTimeMillis() > DiscoveryStateMachine.this.timestamp + DISCOVERY_INTERVAL_MS * 60L) {
                DiscoveryStateMachine.this.timestamp = System.currentTimeMillis();
                return true;
            }
            return false;
        }
    }

    private class ConnectedState
    extends DiscoveryState {
        public ConnectedState() {
            super("Connected");
        }

        @Override
        public boolean isTimeToConnect() {
            return false;
        }
    }

    private class ConnectingState
    extends DiscoveryState {
        public ConnectingState() {
            super("Connecting");
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean isTimeToConnect() {
            return false;
        }
    }

    private class InitState
    extends DiscoveryState {
        public InitState() {
            super("Init");
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean isTimeToConnect() {
            return true;
        }
    }

    private abstract class DiscoveryState {
        private final String name;

        public DiscoveryState(String name) {
            this.name = name;
        }

        public void enter() {
            DiscoveryStateMachine.this.badCount = 0;
            DiscoveryStateMachine.this.previousBadState = null;
            DiscoveryStateMachine.this.previousLogTimeStamp = 0L;
        }

        public boolean isTimeToConnect() {
            return true;
        }

        public String toString() {
            return this.name;
        }
    }
}

