/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

public class Node {
    private final String host;
    private final int port;
    private final int groupPort;
    private final int hashCode;

    public Node(String host, int port) {
        this(host, port, 0);
    }

    public Node(String host, int port, int groupPort) {
        Node.checkArgs(host, port);
        this.host = host.trim();
        this.port = port;
        this.groupPort = groupPort;
        this.hashCode = (host + "-" + port).hashCode();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getGroupPort() {
        return this.groupPort;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            Node that = (Node)obj;
            return this.port == that.port && this.host.equals(that.host);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static void checkArgs(String host, int port) throws IllegalArgumentException {
        if (host == null || host.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid host name: " + host);
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port number: " + port);
        }
    }

    public String toString() {
        return "Node{host=" + this.host + ":" + this.port + "}";
    }

    public String getServerNodeName() {
        return this.host + ":" + this.port;
    }
}

